/*
 * Decompiled with CFR 0.152.
 */
package com.shippo;

import com.shippo.Shippo;
import com.shippo.exception.ShippoException;
import com.shippo.model.Rate;
import com.shippo.model.Shipment;
import com.shippo.model.Transaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Example {
    public static void main(String[] args) throws ShippoException {
        Shippo.setApiKey("<API-KEY>");
        HashMap<String, String> toAddressMap = new HashMap<String, String>();
        toAddressMap.put("name", "Mr Hippo");
        toAddressMap.put("company", "Shippo");
        toAddressMap.put("street1", "215 Clayton St.");
        toAddressMap.put("city", "San Francisco");
        toAddressMap.put("state", "CA");
        toAddressMap.put("zip", "94117");
        toAddressMap.put("country", "US");
        toAddressMap.put("phone", "+1 555 341 9393");
        toAddressMap.put("email", "mrhippo@goshipppo.com");
        HashMap<String, String> fromAddressMap = new HashMap<String, String>();
        fromAddressMap.put("name", "Ms Hippo");
        fromAddressMap.put("company", "San Diego Zoo");
        fromAddressMap.put("street1", "2920 Zoo Drive");
        fromAddressMap.put("city", "San Diego");
        fromAddressMap.put("state", "CA");
        fromAddressMap.put("zip", "92101");
        fromAddressMap.put("country", "US");
        fromAddressMap.put("email", "mshippo@goshipppo.com");
        fromAddressMap.put("phone", "+1 619 231 1515");
        fromAddressMap.put("metadata", "Customer ID 123456");
        HashMap<String, String> parcelMap = new HashMap<String, String>();
        parcelMap.put("length", "5");
        parcelMap.put("width", "5");
        parcelMap.put("height", "5");
        parcelMap.put("distance_unit", "in");
        parcelMap.put("weight", "2");
        parcelMap.put("mass_unit", "lb");
        ArrayList<HashMap<String, String>> parcels = new ArrayList<HashMap<String, String>>();
        parcels.add(parcelMap);
        HashMap<String, Object> shipmentMap = new HashMap<String, Object>();
        shipmentMap.put("address_to", toAddressMap);
        shipmentMap.put("address_from", fromAddressMap);
        shipmentMap.put("parcels", parcels);
        shipmentMap.put("async", false);
        Shipment shipment = Shipment.create(shipmentMap);
        List<Rate> rates = shipment.getRates();
        Rate rate = rates.get(0);
        System.out.println("Getting shipping label..");
        HashMap<String, Object> transParams = new HashMap<String, Object>();
        transParams.put("rate", rate.getObjectId());
        transParams.put("async", false);
        Transaction transaction = Transaction.create(transParams);
        if (transaction.getStatus().equals("SUCCESS")) {
            System.out.println(String.format("Label url : %s", transaction.getLabelUrl()));
            System.out.println(String.format("Tracking number : %s", transaction.getTrackingNumber()));
        } else {
            System.out.println(String.format("An Error has occured while generating you label. Messages : %s", transaction.getMessages()));
        }
    }
}

