/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.model;

import com.google.gson.annotations.SerializedName;
import com.shippo.exception.APIConnectionException;
import com.shippo.exception.APIException;
import com.shippo.exception.AuthenticationException;
import com.shippo.exception.InvalidRequestException;
import com.shippo.model.BatchShipment;
import com.shippo.model.LabelFileType;
import com.shippo.net.APIResource;
import com.shippo.util.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Batch
extends APIResource {
    @SerializedName(value="object_id")
    private String id;
    @SerializedName(value="object_owner")
    private String owner;
    @SerializedName(value="status")
    private BatchStatus status;
    @SerializedName(value="object_created")
    private Date created;
    @SerializedName(value="object_updated")
    private Date updated;
    @SerializedName(value="metadata")
    private String metadata;
    @SerializedName(value="default_carrier_account")
    private String defaultCarrierAccount;
    @SerializedName(value="default_servicelevel_token")
    private String defaultServiceLevelToken;
    @SerializedName(value="label_filetype")
    private LabelFileType labelFileType;
    @SerializedName(value="batch_shipments")
    private BatchShipmentCollection batchShipments;
    @SerializedName(value="label_url")
    private String[] labelURLs;
    @SerializedName(value="object_results")
    private Counts objectResults;

    public String toString() {
        return "Batch [id=" + this.id + ", owner=" + this.owner + ", status=" + (Object)((Object)this.status) + ", created=" + this.created + ", updated=" + this.updated + ", metadata=" + this.metadata + ", defaultCarrierAccount=" + this.defaultCarrierAccount + ", defaultServiceLevelToken=" + this.defaultServiceLevelToken + ", labelFileType=" + (Object)((Object)this.labelFileType) + ", batchShipments=" + this.batchShipments + ", labelURLs=" + Arrays.toString(this.labelURLs) + ", objectResults=" + this.objectResults + "]";
    }

    public static Batch[] all() throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, UnsupportedEncodingException, MalformedURLException {
        ArrayList<Batch> all_batches = new ArrayList<Batch>();
        Map<Object, Object> params = new HashMap();
        while (true) {
            HashMap<String, Object> reqParams = new HashMap<String, Object>(params);
            BatchCollection coll = Batch.request(APIResource.RequestMethod.GET, Batch.classURL(Batch.class), reqParams, BatchCollection.class, null);
            if (coll.array.length == 0) break;
            all_batches.addAll(Arrays.asList(coll.array));
            if (coll.next == null) break;
            params = HttpUtil.queryToParams(new URL(coll.next).getQuery());
        }
        Batch[] array = new Batch[all_batches.size()];
        all_batches.toArray(array);
        return array;
    }

    public static Batch create(String carrierAccount, String serviceLevelToken, LabelFileType labelFileType, String metadata, BatchShipment[] shipments) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("default_carrier_account", carrierAccount);
        params.put("default_servicelevel_token", serviceLevelToken);
        params.put("label_filetype", labelFileType.toString());
        params.put("batch_shipments", shipments);
        return Batch.request(APIResource.RequestMethod.POST, Batch.classURL(Batch.class), params, Batch.class, null);
    }

    public static Batch get(String id, int page, ShipmentStatus objectResults) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (page != 0) {
            params.put("page", page);
        }
        if (objectResults != null) {
            params.put("object_results", objectResults.toString());
        }
        return Batch.request(APIResource.RequestMethod.GET, Batch.instanceURL(Batch.class, id), params, Batch.class, null);
    }

    public static Batch addShipments(String id, String[] shipmentIds) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        BatchShipmentId[] array = new BatchShipmentId[shipmentIds.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new BatchShipmentId(shipmentIds[i]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("__list", array);
        return Batch.request(APIResource.RequestMethod.POST, Batch.instanceURL(Batch.class, id) + "/add_shipments", params, Batch.class, null);
    }

    public static Batch removeShipments(String id, String[] shipmentIds) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("__list", shipmentIds);
        return Batch.request(APIResource.RequestMethod.POST, Batch.instanceURL(Batch.class, id) + "/remove_shipments", params, Batch.class, null);
    }

    public static Batch purchase(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Batch.request(APIResource.RequestMethod.POST, Batch.instanceURL(Batch.class, id) + "/purchase", null, Batch.class, null);
    }

    public String getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getDefaultCarrierAccount() {
        return this.defaultCarrierAccount;
    }

    public String getDefaultServiceLevelToken() {
        return this.defaultServiceLevelToken;
    }

    public LabelFileType getLabelFileType() {
        return this.labelFileType;
    }

    public BatchShipmentCollection getBatchShipments() {
        return this.batchShipments;
    }

    public String[] getLabelURLs() {
        return this.labelURLs;
    }

    public Counts getObjectResults() {
        return this.objectResults;
    }

    private static class BatchShipmentId {
        @SerializedName(value="shipment")
        private String id;

        public BatchShipmentId(String id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShipmentStatus {
        PURCHASE_SUCCEEDED("purchase_succeeded"),
        PURCHASE_FAILED("purchase_failed"),
        CREATION_SUCCEEDED("creation_succeeded"),
        CREATION_FAILED("creation_failed");

        private final String apiText;

        private ShipmentStatus(String apiText) {
            this.apiText = apiText;
        }

        public String toString() {
            return this.apiText;
        }
    }

    private static class BatchCollection {
        private String next;
        @SerializedName(value="results")
        private Batch[] array;

        private BatchCollection() {
        }
    }

    public static class Counts {
        @SerializedName(value="creation_succeeded")
        private int creationSucceeded;
        @SerializedName(value="creation_failed")
        private int creationFailed;
        @SerializedName(value="purchase_succeeded")
        private int purchaseSucceeded;
        @SerializedName(value="purchase_failed")
        private int purchaseFailed;

        public String toString() {
            return "Counts [creationSucceeded=" + this.creationSucceeded + ", creationFailed=" + this.creationFailed + ", purchaseSucceeded=" + this.purchaseSucceeded + ", purchaseFailed=" + this.purchaseFailed + "]";
        }

        public int getCreationSucceeded() {
            return this.creationSucceeded;
        }

        public int getCreationFailed() {
            return this.creationFailed;
        }

        public int getPurchaseSucceeded() {
            return this.purchaseSucceeded;
        }

        public int getPurchaseFailed() {
            return this.purchaseFailed;
        }
    }

    public static class BatchShipmentCollection {
        private int count;
        private String next;
        private String previous;
        @SerializedName(value="results")
        private BatchShipment[] shipments;

        public String toString() {
            return "BatchShipmentCollection [next=" + this.next + ", shipments=" + Arrays.toString(this.shipments) + "]";
        }

        public String getNext() {
            return this.next;
        }

        public String getPrevious() {
            return this.previous;
        }

        public BatchShipment[] getShipments() {
            return this.shipments;
        }

        public int getCount() {
            return this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchStatus {
        VALIDATING,
        VALID,
        INVALID,
        PURCHASING,
        PURCHASED;

    }
}

