/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.model;

import com.shippo.Shippo;
import com.shippo.exception.APIConnectionException;
import com.shippo.exception.APIException;
import com.shippo.exception.AuthenticationException;
import com.shippo.exception.InvalidRequestException;
import com.shippo.exception.RequestTimeoutException;
import com.shippo.model.Address;
import com.shippo.model.Parcel;
import com.shippo.model.Rate;
import com.shippo.model.RateCollection;
import com.shippo.model.ShipmentCollection;
import com.shippo.net.APIResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shipment
extends APIResource {
    String status;
    String objectId;
    String objectOwner;
    Object objectCreated;
    Object objectUpdated;
    Object addressFrom;
    Object addressTo;
    Object addressReturn;
    List<Parcel> parcels;
    Object shipmentDate;
    Object extra;
    Object customsDeclaration;
    Object ratesUrl;
    Object metadata;
    Object messages;
    List<Rate> rates;

    public static Shipment createForBatch(Address from, Address to, List<Parcel> parcels) {
        Shipment s = new Shipment();
        s.addressFrom = from;
        s.addressTo = to;
        s.parcels = parcels;
        return s;
    }

    public static Shipment create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.create(params, null);
    }

    public String getInstanceURL() {
        return "";
    }

    public static Shipment create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.POST, Shipment.classURL(Shipment.class), params, Shipment.class, apiKey);
    }

    public static RateCollection getShippingRatesSync(String object_id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, RequestTimeoutException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", object_id);
        params.put("currency_code", "");
        return Shipment.getShippingRatesSync(params, null);
    }

    public static RateCollection getShippingRatesSync(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, RequestTimeoutException {
        return Shipment.getShippingRatesSync(params, null);
    }

    public static RateCollection getShippingRatesSync(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, RequestTimeoutException {
        String object_id = (String)params.get("id");
        Shipment shipment = Shipment.retrieve(object_id);
        String status = shipment.status;
        long startTime = System.currentTimeMillis();
        while (status.equals("QUEUED") || status.equals("WAITING")) {
            if (System.currentTimeMillis() - startTime > (long)Shippo.RATES_REQ_TIMEOUT) {
                throw new RequestTimeoutException("A timeout has occured while waiting for your rates to generate. Try retreiving the Shipment object again and check if status is updated. If this issue persists, please contact support@goshippo.com");
            }
            shipment = Shipment.retrieve(object_id);
            status = shipment.status;
        }
        return Shipment.getShippingRates(params, apiKey);
    }

    public static Shipment retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.retrieve(id, null);
    }

    public static Shipment retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.GET, Shipment.instanceURL(Shipment.class, id), null, Shipment.class, apiKey);
    }

    public static ShipmentCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.all(params, null);
    }

    public static ShipmentCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.GET, Shipment.classURL(Shipment.class), params, ShipmentCollection.class, apiKey);
    }

    public static RateCollection getShippingRates(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.getShippingRates(params, null);
    }

    public static RateCollection getShippingRates(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.GET, Shipment.instanceURL(Shipment.class, id) + "/rates/", null, RateCollection.class, apiKey);
    }

    public static RateCollection getShippingRates(String id, String currency_code, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.GET, Shipment.instanceURL(Shipment.class, id) + "/rates/" + currency_code, null, RateCollection.class, apiKey);
    }

    public static RateCollection getShippingRates(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Shipment.request(APIResource.RequestMethod.GET, Shipment.instanceURL(Shipment.class, (String)params.get("id")) + "/rates/" + params.get("currency_code"), null, RateCollection.class, apiKey);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = objectOwner;
    }

    public Object getObjectCreated() {
        return this.objectCreated;
    }

    public void setObjectCreated(Object objectCreated) {
        this.objectCreated = objectCreated;
    }

    public Object getObjectUpdated() {
        return this.objectUpdated;
    }

    public void setObjectUpdated(Object objectUpdated) {
        this.objectUpdated = objectUpdated;
    }

    public Object getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(Object addressFrom) {
        this.addressFrom = addressFrom;
    }

    public Object getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(Object addressTo) {
        this.addressTo = addressTo;
    }

    public Object getAddressReturn() {
        return this.addressReturn;
    }

    public void setAddressReturn(Object addressReturn) {
        this.addressReturn = addressReturn;
    }

    public List<Parcel> getParcels() {
        return this.parcels;
    }

    public void setParcels(List<Parcel> parcels) {
        this.parcels = parcels;
    }

    public Object getShipmentDate() {
        return this.shipmentDate;
    }

    public void setShipmentDate(Object shipmentDate) {
        this.shipmentDate = shipmentDate;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public Object getCustomsDeclaration() {
        return this.customsDeclaration;
    }

    public void setCustomsDeclaration(Object customsDeclaration) {
        this.customsDeclaration = customsDeclaration;
    }

    public Object getRatesUrl() {
        return this.ratesUrl;
    }

    public void setRatesUrl(Object ratesUrl) {
        this.ratesUrl = ratesUrl;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public void setRates(List<Rate> rates) {
        this.rates = rates;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public Object getMessages() {
        return this.messages;
    }

    public void setMessages(Object messages) {
        this.messages = messages;
    }
}

