/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.model;

import com.google.gson.annotations.SerializedName;
import com.shippo.exception.APIConnectionException;
import com.shippo.exception.APIException;
import com.shippo.exception.AuthenticationException;
import com.shippo.exception.InvalidRequestException;
import com.shippo.net.APIResource;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public final class Track
extends APIResource {
    private String carrier;
    private String trackingNumber;
    private Address addressFrom;
    private Address addressTo;
    private Date eta;
    @SerializedName(value="servicelevel")
    private ServiceLevel serviceLevel;
    private String metadata;
    private TrackingEvent trackingStatus;
    private TrackingEvent[] trackingHistory;

    public String toString() {
        return "Track [carrier=" + this.carrier + ", tracking_number=" + this.trackingNumber + ", addressFrom=" + this.addressFrom + ", addressTo=" + this.addressTo + ", eta=" + this.eta + ", serviceLevel=" + this.serviceLevel + ", metadata=" + this.metadata + ", tracking_status=" + this.trackingStatus + ", tracking_history=" + Arrays.toString(this.trackingHistory) + "]";
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public Address getAddressFrom() {
        return this.addressFrom;
    }

    public Address getAddressTo() {
        return this.addressTo;
    }

    public Date getETA() {
        return this.eta;
    }

    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public TrackingEvent getTrackingStatus() {
        return this.trackingStatus;
    }

    public TrackingEvent[] getTrackingHistory() {
        return this.trackingHistory;
    }

    private static String trackingNumberURL(String carrier, String trackingNumber) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        try {
            return String.format("%s/%s/%s", Track.classURL(Track.class), Track.urlEncode(carrier), Track.urlEncode(trackingNumber));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@goshippo.com for assistance.", null, e);
        }
    }

    public static Track getTrackingInfo(String carrier, String trackingNumber, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Track.request(APIResource.RequestMethod.GET, Track.trackingNumberURL(carrier, trackingNumber), null, Track.class, apiKey);
    }

    public static Track registerTrackingWebhook(String carrier, String trackingNumber, String metadata, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("carrier", carrier);
        params.put("tracking_number", trackingNumber);
        params.put("metadata", metadata);
        return Track.request(APIResource.RequestMethod.POST, Track.classURLWithTrailingSlash(Track.class), params, Track.class, apiKey);
    }

    public static class TrackingEvent {
        private Date objectCreated;
        private Date objectUpdated;
        private String objectId;
        private TrackingStatus status;
        private String statusDetails;
        private Date statusDate;
        private Address location;

        public String toString() {
            return "TrackingEvent [objectCreated=" + this.objectCreated + ", objectUpdated=" + this.objectUpdated + ", objectId=" + this.objectId + ", status=" + (Object)((Object)this.status) + ", statusDetails=" + this.statusDetails + ", statusDate=" + this.statusDate + ", location=" + this.location + "]";
        }

        public Date getObjectCreated() {
            return this.objectCreated;
        }

        public Date getObjectUpdated() {
            return this.objectUpdated;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public TrackingStatus getStatus() {
            return this.status;
        }

        public String getStatusDetails() {
            return this.statusDetails;
        }

        public Date getStatusDate() {
            return this.statusDate;
        }

        public Address getLocation() {
            return this.location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrackingStatus {
        UNKNOWN,
        DELIVERED,
        TRANSIT,
        FAILURE,
        RETURNED;

    }

    public static class ServiceLevel {
        private String token;
        private String name;

        public String getToken() {
            return this.token;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "ServiceLevel [token=" + this.token + ", name=" + this.name + "]";
        }
    }

    public static class Address {
        private String city;
        private String state;
        private String zip;
        private String country;

        public String toString() {
            return "Address [city=" + this.city + ", state=" + this.state + ", zip=" + this.zip + ", country=" + this.country + "]";
        }
    }
}

