/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.model;

import com.shippo.Shippo;
import com.shippo.exception.APIConnectionException;
import com.shippo.exception.APIException;
import com.shippo.exception.AuthenticationException;
import com.shippo.exception.InvalidRequestException;
import com.shippo.exception.RequestTimeoutException;
import com.shippo.model.TransactionCollection;
import com.shippo.net.APIResource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends APIResource {
    String status;
    String objectId;
    String objectOwner;
    Object objectCreated;
    Object objectUpdated;
    Object commercialInvoiceUrl;
    Object wasTest;
    Object rate;
    Object trackingNumber;
    Object trackingStatus;
    Object trackingUrlProvider;
    Object labelUrl;
    Object messages;
    Object metadata;

    public static Transaction create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.create(params, null);
    }

    public String getInstanceURL() {
        return "";
    }

    public static Transaction create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.request(APIResource.RequestMethod.POST, Transaction.classURL(Transaction.class), params, Transaction.class, apiKey);
    }

    public static Transaction createSync(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, RequestTimeoutException {
        return Transaction.createSync(params, null);
    }

    public static Transaction createSync(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, RequestTimeoutException {
        Transaction transaction = Transaction.request(APIResource.RequestMethod.POST, Transaction.classURL(Transaction.class), params, Transaction.class, apiKey);
        String object_id = transaction.objectId;
        String status = transaction.status;
        long startTime = System.currentTimeMillis();
        while (status.equals("QUEUED") || status.equals("WAITING")) {
            if (System.currentTimeMillis() - startTime > (long)Shippo.TRANSACTION_REQ_TIMEOUT) {
                throw new RequestTimeoutException("A timeout has occured while waiting for your label to generate. Try retreiving the Transaction object again and check if status is updated. If this issue persists, please contact support@goshippo.com");
            }
            transaction = Transaction.retrieve(object_id);
            status = transaction.status;
        }
        return transaction;
    }

    public static Transaction retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.retrieve(id, null);
    }

    public static Transaction retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.request(APIResource.RequestMethod.GET, Transaction.instanceURL(Transaction.class, id), null, Transaction.class, apiKey);
    }

    public static TransactionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.all(params, null);
    }

    public static TransactionCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Transaction.request(APIResource.RequestMethod.GET, Transaction.classURL(Transaction.class), params, TransactionCollection.class, apiKey);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public void setObjectOwner(String objectOwner) {
        this.objectOwner = objectOwner;
    }

    public Object getObjectCreated() {
        return this.objectCreated;
    }

    public void setObjectCreated(Object objectCreated) {
        this.objectCreated = objectCreated;
    }

    public Object getWasTest() {
        return this.wasTest;
    }

    public void setWasTest(Object wasTest) {
        this.wasTest = wasTest;
    }

    public Object getRate() {
        return this.rate;
    }

    public void setRate(Object rate) {
        this.rate = rate;
    }

    public Object getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(Object trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public Object getTrackingStatus() {
        return this.trackingStatus;
    }

    public void setTrackingStatus(Object trackingStatus) {
        this.trackingStatus = trackingStatus;
    }

    public Object getTrackingUrlProvider() {
        return this.trackingUrlProvider;
    }

    public void setTrackingUrlProvider(Object trackingUrlProvider) {
        this.trackingUrlProvider = trackingUrlProvider;
    }

    public Object getLabelUrl() {
        return this.labelUrl;
    }

    public void setLabelUrl(Object labelUrl) {
        this.labelUrl = labelUrl;
    }

    public Object getMessages() {
        return this.messages;
    }

    public void setMessages(Object messages) {
        this.messages = messages;
    }

    public Object getCommercialInvoiceUrl() {
        return this.commercialInvoiceUrl;
    }

    public void setCommercialInvoiceUrl(Object commercialInvoiceUrl) {
        this.commercialInvoiceUrl = commercialInvoiceUrl;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }
}

