/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.net;

import com.google.gson.Gson;
import com.shippo.Shippo;
import com.shippo.exception.APIConnectionException;
import com.shippo.exception.APIException;
import com.shippo.exception.AuthenticationException;
import com.shippo.exception.InvalidRequestException;
import com.shippo.net.ShippoResponse;
import com.shippo.serialization.GsonFactory;
import com.shippo.serialization.ShippoObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APIResource
extends ShippoObject {
    public static final String CHARSET = "UTF-8";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "com.shippo.net.customURLStreamHandler";

    private static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (className.equals("address")) {
            return "addresse";
        }
        if (className.equals("customsitem")) {
            return "customs/item";
        }
        if (className.equals("customsdeclaration")) {
            return "customs/declaration";
        }
        if (className.equals("carrieraccount")) {
            return "carrier_account";
        }
        if (className.equals("batch")) {
            return "batche";
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/%s", Shippo.getApiBase(), APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String classURLWithTrailingSlash(Class<?> clazz) {
        return String.format("%ss/", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@goshippo.com for assistance.", null, e);
        }
    }

    protected static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", APIResource.urlEncode(k), APIResource.urlEncode(v));
    }

    static Map<String, String> getHeaders(String apiKey, Class<?> clazz) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("Shippo/v1 JavaBindings/%s", "1.0"));
        if (apiKey == null) {
            apiKey = Shippo.apiKey;
        }
        headers.put("Authorization", String.format("ShippoToken %s", apiKey));
        headers.put("Accept", "application/json");
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        headers.put("User-Agent", GsonFactory.getGson(clazz).toJson(propertyMap));
        headers.put("Content-Type", "application/json");
        if (Shippo.apiVersion != null) {
            headers.put("Shippo-API-Version", Shippo.apiVersion);
        }
        return headers;
    }

    private static HttpURLConnection createShippoConnection(String url, String apiKey, Class<?> clazz) throws IOException {
        URL shippoURL;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> urlClass = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = urlClass.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                shippoURL = new URL(null, url, customHandler);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        } else {
            shippoURL = new URL(url);
        }
        HttpURLConnection conn = (HttpURLConnection)shippoURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : APIResource.getHeaders(apiKey, clazz).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static void throwInvalidCertificateException() throws APIConnectionException {
        throw new APIConnectionException("Invalid server certificate. You tried to connect to a server that has a revoked SSL certificate, which means we cannot securely send data to that server. Please email support@goshippo.com if you need help connecting to the correct API server.");
    }

    private static void checkSSLCert(HttpURLConnection hconn) throws IOException, APIConnectionException {
        if (!Shippo.getVerifySSL() && !hconn.getURL().getHost().equals("api.shippo.com")) {
            return;
        }
        HttpsURLConnection conn = (HttpsURLConnection)hconn;
        conn.connect();
        Certificate[] certs = conn.getServerCertificates();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certs[0].getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            byte[] revokedCertDigest = new byte[]{};
            if (Arrays.equals(digest, revokedCertDigest)) {
                APIResource.throwInvalidCertificateException();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateEncodingException e) {
            APIResource.throwInvalidCertificateException();
        }
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, String apiKey, Class<?> clazz) throws IOException, APIConnectionException {
        if (Shippo.isDEBUG()) {
            System.out.println("GET URL: " + url);
        }
        String getURL = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createShippoConnection(getURL, apiKey, clazz);
        conn.setRequestMethod("GET");
        APIResource.checkSSLCert(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostPutConnection(String url, String query, RequestMethod method, String apiKey, Class<?> clazz) throws IOException, APIConnectionException {
        if (Shippo.isDEBUG()) {
            System.out.println("POST URL: " + url);
        }
        HttpURLConnection conn = APIResource.createShippoConnection(url, apiKey, clazz);
        conn.setDoOutput(true);
        conn.setRequestMethod(method.toString());
        conn.setRequestProperty("Content-Type", "application/json");
        APIResource.checkSSLCert(conn);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPutConnection(String url, String query, String apiKey, Class<?> clazz) throws IOException, APIConnectionException {
        if (Shippo.isDEBUG()) {
            System.out.println("PUT URL: " + url);
        }
        HttpURLConnection conn = APIResource.createShippoConnection(url, apiKey, clazz);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Content-Type", "application/json");
        APIResource.checkSSLCert(conn);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private static String mapToJson(Map<String, Object> params, Class<?> clazz) {
        Gson gson = GsonFactory.getGson(clazz);
        if (params == null) {
            return gson.toJson(new HashMap());
        }
        Object o = params.get("__list");
        if (o != null) {
            return gson.toJson(o);
        }
        return gson.toJson(params);
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static ShippoResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey, Class<?> clazz) throws APIConnectionException {
        HttpURLConnection conn = null;
        if (Shippo.isDEBUG()) {
            System.out.println("URL: " + url);
            System.out.println("Query: " + query);
            System.out.println("API Key: " + apiKey);
        }
        try {
            if (method.equals((Object)RequestMethod.GET)) {
                conn = APIResource.createGetConnection(url, query, apiKey, clazz);
            } else if (method.equals((Object)RequestMethod.POST) || method.equals((Object)RequestMethod.PUT)) {
                conn = APIResource.createPostPutConnection(url, query, method, apiKey, clazz);
            } else {
                throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the Shippo bindings. Please contact support@goshippo.com for assistance.", new Object[]{method}));
            }
            int rCode = conn.getResponseCode();
            String rBody = rCode >= 200 && rCode < 300 ? APIResource.getResponseBody(conn.getInputStream()) : APIResource.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            if (Shippo.isDEBUG()) {
                System.out.println("Headers: ");
                for (Map.Entry entry : headers.entrySet()) {
                    System.out.println((String)entry.getKey() + " : " + entry.getValue());
                }
                System.out.println("Response Code: " + rCode);
                System.out.println("Reponse Body: " + rBody);
            }
            ShippoResponse shippoResponse = new ShippoResponse(rCode, rBody, headers);
            return shippoResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Shippo (%s): %s Please check your internet connection and try again. If this problem persists,you should check Shippo's service status at http://status.goshippo.com/, or let us know at support@goshippo.com.", Shippo.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            T t = APIResource._request(method, url, params, clazz, apiKey);
            return t;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    protected static <T> T _request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String query;
        if (!(Shippo.apiKey != null && Shippo.apiKey.length() != 0 || apiKey != null && apiKey.length() != 0)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Shippo.apiKey = <API-KEY>'. You can generate API keys from the Shippo web interface. See https://goshippo.com/docs for details or email support@goshippo.com if you have questions.");
        }
        if (apiKey == null) {
            apiKey = Shippo.apiKey;
        }
        try {
            query = APIResource.createQuery(params, method, clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8. Please contact support@shippo.com for assistance.", null, e);
        }
        ShippoResponse response = APIResource.makeURLConnectionRequest(method, url, query, apiKey, clazz);
        int rCode = response.responseCode;
        String rBody = response.responseBody;
        if (rCode < 200 || rCode >= 300) {
            APIResource.handleAPIError(rBody, rCode);
        }
        return (T)GsonFactory.getGson(clazz).fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, APIException {
        Error error = new Error();
        error.message = rBody;
        error.code = rCode + "";
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.message, error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.message);
            }
        }
        throw new APIException(error.message, null);
    }

    private static String createGETQuery(Map<String, Object> params, Class<?> clazz) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> flatParams = APIResource.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String createQuery(Map<String, Object> params, RequestMethod method, Class<?> clazz) throws UnsupportedEncodingException, InvalidRequestException {
        switch (method) {
            case GET: {
                return APIResource.createGETQuery(params, clazz);
            }
            case POST: {
                return APIResource.mapToJson(params, clazz);
            }
        }
        return APIResource.mapToJson(params, clazz);
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum RequestMethod {
        GET,
        POST,
        PUT;

    }
}

