/*
 * Decompiled with CFR 0.152.
 */
package com.shippo.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.shippo.model.Address;
import com.shippo.model.Shipment;
import com.shippo.serialization.GsonFactory;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShipmentDeserializer
implements JsonDeserializer<Shipment> {
    public Shipment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Address addressReturn;
        Address addressFrom;
        Shipment shipment = (Shipment)GsonFactory.DEFAULT_GSON.fromJson(json, Shipment.class);
        JsonObject jsonObject = json.getAsJsonObject();
        Address addressTo = this.getAddress(jsonObject, "address_to");
        if (addressTo != null) {
            shipment.setAddressTo(addressTo);
        }
        if ((addressFrom = this.getAddress(jsonObject, "address_from")) != null) {
            shipment.setAddressFrom(addressFrom);
        }
        if ((addressReturn = this.getAddress(jsonObject, "address_return")) != null) {
            shipment.setAddressReturn(addressReturn);
        }
        return shipment;
    }

    private Address getAddress(JsonObject jsonObject, String address_key) {
        String valuesString;
        JsonElement elem;
        if (jsonObject.has(address_key) && (elem = jsonObject.get(address_key)) != null && !elem.isJsonNull() && (valuesString = elem.toString()) != null && !valuesString.isEmpty()) {
            try {
                return (Address)GsonFactory.DEFAULT_GSON.fromJson(valuesString, Address.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }
}

