/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.error;

import com.google.cloud.bigquery.BigQueryError;
import com.gotocompany.depot.bigquery.error.ErrorDescriptor;
import com.gotocompany.depot.bigquery.error.InvalidSchemaError;
import com.gotocompany.depot.bigquery.error.OOBError;
import com.gotocompany.depot.bigquery.error.StoppedError;
import com.gotocompany.depot.bigquery.error.UnknownError;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ErrorParser {
    public static ErrorDescriptor getError(String reasonText, String msgText) {
        List<ErrorDescriptor> errDescList = Arrays.asList(new InvalidSchemaError(reasonText, msgText), new OOBError(reasonText, msgText), new StoppedError(reasonText));
        return errDescList.stream().filter(ErrorDescriptor::matches).findFirst().orElse(new UnknownError(reasonText, msgText));
    }

    public static List<ErrorDescriptor> parseError(List<BigQueryError> bqErrors) {
        return bqErrors.stream().map(err -> ErrorParser.getError(err.getReason(), err.getMessage())).collect(Collectors.toList());
    }
}

