/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.json;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.gotocompany.depot.bigquery.client.BigQueryClient;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverter;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverterCache;
import com.gotocompany.depot.bigquery.exception.BQTableUpdateFailure;
import com.gotocompany.depot.bigquery.proto.BigqueryFields;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BigqueryJsonUpdateListener
extends DepotStencilUpdateListener {
    private final MessageRecordConverterCache converterCache;
    private final BigQuerySinkConfig config;
    private final BigQueryClient bigQueryClient;
    private final Instrumentation instrumentation;

    public BigqueryJsonUpdateListener(BigQuerySinkConfig config, MessageRecordConverterCache converterCache, BigQueryClient bigQueryClient, Instrumentation instrumentation) {
        this.converterCache = converterCache;
        this.config = config;
        this.bigQueryClient = bigQueryClient;
        this.instrumentation = instrumentation;
        if (!config.getSinkBigqueryDynamicSchemaEnable()) {
            throw new UnsupportedOperationException("currently only schema inferred from incoming data is supported, stencil schema support for json will be added in future");
        }
    }

    @Override
    public void updateSchema() {
        MessageParser parser = this.getMessageParser();
        MessageRecordConverter messageRecordConverter = new MessageRecordConverter(parser, this.config);
        this.converterCache.setMessageRecordConverter(messageRecordConverter);
        List<TupleString> defaultColumns = this.config.getSinkBigqueryDefaultColumns();
        HashSet fieldsToBeUpdated = defaultColumns.stream().map(this::getField).collect(Collectors.toCollection(HashSet::new));
        if (this.config.shouldAddMetadata() && !this.config.getBqMetadataNamespace().isEmpty()) {
            throw new UnsupportedOperationException("metadata namespace is not supported, because nested json structure is not supported");
        }
        this.addMetadataFields(fieldsToBeUpdated, defaultColumns);
        try {
            Schema existingTableSchema = this.bigQueryClient.getSchema();
            FieldList existingTableFields = existingTableSchema.getFields();
            existingTableFields.iterator().forEachRemaining(fieldsToBeUpdated::add);
            this.bigQueryClient.upsertTable(new ArrayList<Field>(fieldsToBeUpdated));
        }
        catch (BigQueryException e) {
            String errMsg = "Error while updating bigquery table in json update listener:" + e.getMessage();
            this.instrumentation.logError(errMsg, new Object[0]);
            throw new BQTableUpdateFailure(errMsg, e);
        }
    }

    private void addMetadataFields(HashSet<Field> fieldsToBeUpdated, List<TupleString> defaultColumns) {
        if (this.config.shouldAddMetadata()) {
            Set defaultColumnNames = defaultColumns.stream().map(TupleString::getFirst).collect(Collectors.toSet());
            List<TupleString> metadataColumnsTypes = this.config.getMetadataColumnsTypes();
            List<Field> metadataFields = BigqueryFields.getMetadataFieldsStrict(metadataColumnsTypes);
            Optional<Field> duplicateField = metadataFields.stream().filter(m -> defaultColumnNames.contains(m.getName())).findFirst();
            if (duplicateField.isPresent()) {
                String duplicateFieldName = duplicateField.get().getName();
                this.instrumentation.logError("duplicate key found in default columns and metadata config {}", duplicateFieldName);
                throw new IllegalArgumentException("duplicate field called " + duplicateFieldName + " is present in both default columns config and metadata config");
            }
            fieldsToBeUpdated.addAll(metadataFields);
        }
    }

    private Field getField(TupleString tupleString) {
        String fieldName = tupleString.getFirst();
        LegacySQLTypeName fieldDataType = LegacySQLTypeName.valueOfStrict((String)tupleString.getSecond().toUpperCase());
        return this.checkAndCreateField(fieldName, fieldDataType);
    }

    private Field checkAndCreateField(String fieldName, LegacySQLTypeName fieldDataType) {
        boolean isValidPartitionDataType;
        Boolean isPartitioningEnabled = this.config.isTablePartitioningEnabled();
        if (!isPartitioningEnabled.booleanValue()) {
            return Field.newBuilder((String)fieldName, (LegacySQLTypeName)fieldDataType, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
        }
        String partitionKey = this.config.getTablePartitionKey();
        boolean bl = isValidPartitionDataType = fieldDataType == LegacySQLTypeName.TIMESTAMP || fieldDataType == LegacySQLTypeName.DATE;
        if (partitionKey.equals(fieldName) && !isValidPartitionDataType) {
            throw new UnsupportedOperationException("supported partition fields have to be of DATE or TIMESTAMP type..");
        }
        return Field.newBuilder((String)fieldName, (LegacySQLTypeName)fieldDataType, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    }
}

