/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.models;

import com.gotocompany.depot.error.ErrorInfo;
import java.util.Map;

public class Record {
    private final Map<String, Object> metadata;
    private final Map<String, Object> columns;
    private final long index;
    private final ErrorInfo errorInfo;

    public static RecordBuilder builder() {
        return new RecordBuilder();
    }

    public Record(Map<String, Object> metadata, Map<String, Object> columns, long index, ErrorInfo errorInfo) {
        this.metadata = metadata;
        this.columns = columns;
        this.index = index;
        this.errorInfo = errorInfo;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getColumns() {
        return this.columns;
    }

    public long getIndex() {
        return this.index;
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, Object> this$columns = this.getColumns();
        Map<String, Object> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        ErrorInfo this$errorInfo = this.getErrorInfo();
        ErrorInfo other$errorInfo = other.getErrorInfo();
        return !(this$errorInfo == null ? other$errorInfo != null : !((Object)this$errorInfo).equals(other$errorInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Record;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, Object> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        long $index = this.getIndex();
        result = result * 59 + (int)($index >>> 32 ^ $index);
        ErrorInfo $errorInfo = this.getErrorInfo();
        result = result * 59 + ($errorInfo == null ? 43 : ((Object)$errorInfo).hashCode());
        return result;
    }

    public String toString() {
        return "Record(metadata=" + this.getMetadata() + ", columns=" + this.getColumns() + ", index=" + this.getIndex() + ", errorInfo=" + this.getErrorInfo() + ")";
    }

    public static class RecordBuilder {
        private Map<String, Object> metadata;
        private Map<String, Object> columns;
        private long index;
        private ErrorInfo errorInfo;

        RecordBuilder() {
        }

        public RecordBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public RecordBuilder columns(Map<String, Object> columns) {
            this.columns = columns;
            return this;
        }

        public RecordBuilder index(long index) {
            this.index = index;
            return this;
        }

        public RecordBuilder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public Record build() {
            return new Record(this.metadata, this.columns, this.index, this.errorInfo);
        }

        public String toString() {
            return "Record.RecordBuilder(metadata=" + this.metadata + ", columns=" + this.columns + ", index=" + this.index + ", errorInfo=" + this.errorInfo + ")";
        }
    }
}

