/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.proto;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.gotocompany.depot.bigquery.models.BQField;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.message.proto.ProtoField;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BigqueryFields {
    public static List<Field> getMetadataFields(List<TupleString> metadataColumnsTypes) {
        return metadataColumnsTypes.stream().map(tuple -> Field.newBuilder((String)tuple.getFirst(), (LegacySQLTypeName)LegacySQLTypeName.valueOf((String)tuple.getSecond()), (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()).collect(Collectors.toList());
    }

    public static List<Field> getMetadataFieldsStrict(List<TupleString> metadataColumnsTypes) {
        return metadataColumnsTypes.stream().map(tuple -> Field.newBuilder((String)tuple.getFirst(), (LegacySQLTypeName)LegacySQLTypeName.valueOfStrict((String)tuple.getSecond().toUpperCase()), (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()).collect(Collectors.toList());
    }

    public static Field getNamespacedMetadataField(String namespace, List<TupleString> metadataColumnsTypes) {
        return Field.newBuilder((String)namespace, (LegacySQLTypeName)LegacySQLTypeName.RECORD, (FieldList)FieldList.of(BigqueryFields.getMetadataFields(metadataColumnsTypes))).setMode(Field.Mode.NULLABLE).build();
    }

    public static List<Field> generateBigquerySchema(ProtoField protoField) {
        if (protoField == null) {
            return null;
        }
        ArrayList<Field> schemaFields = new ArrayList<Field>();
        for (ProtoField field : protoField.getFields()) {
            BQField bqField = new BQField(field);
            if (field.isNested()) {
                List<Field> fields = BigqueryFields.generateBigquerySchema(field);
                bqField.setSubFields(fields);
            }
            schemaFields.add(bqField.getField());
        }
        return schemaFields;
    }
}

