/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.proto;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.bigquery.client.BigQueryClient;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverter;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverterCache;
import com.gotocompany.depot.bigquery.exception.BQSchemaMappingException;
import com.gotocompany.depot.bigquery.exception.BQTableUpdateFailure;
import com.gotocompany.depot.bigquery.proto.BigqueryFields;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.message.proto.ProtoField;
import com.gotocompany.depot.message.proto.ProtoMessageParser;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigqueryProtoUpdateListener
extends DepotStencilUpdateListener {
    private static final Logger log = LoggerFactory.getLogger(BigqueryProtoUpdateListener.class);
    private final BigQuerySinkConfig config;
    private final BigQueryClient bqClient;
    private final MessageRecordConverterCache converterCache;

    public BigqueryProtoUpdateListener(BigQuerySinkConfig config, BigQueryClient bqClient, MessageRecordConverterCache converterCache) {
        this.config = config;
        this.bqClient = bqClient;
        this.converterCache = converterCache;
    }

    @Override
    public void onSchemaUpdate(Map<String, Descriptors.Descriptor> newDescriptors) {
        log.info("stencil cache was refreshed, validating if bigquery schema changed");
        try {
            SinkConnectorSchemaMessageMode mode = this.config.getSinkConnectorSchemaMessageMode();
            String schemaClass = mode == SinkConnectorSchemaMessageMode.LOG_MESSAGE ? this.config.getSinkConnectorSchemaProtoMessageClass() : this.config.getSinkConnectorSchemaProtoKeyClass();
            ProtoMessageParser messageParser = (ProtoMessageParser)this.getMessageParser();
            ProtoField protoField = newDescriptors == null ? messageParser.getProtoField(schemaClass) : messageParser.getProtoField(schemaClass, newDescriptors);
            List<Field> bqSchemaFields = BigqueryFields.generateBigquerySchema(protoField);
            this.addMetadataFields(bqSchemaFields);
            this.bqClient.upsertTable(bqSchemaFields);
            this.converterCache.setMessageRecordConverter(new MessageRecordConverter(messageParser, this.config));
        }
        catch (BigQueryException | IOException e) {
            String errMsg = "Error while updating bigquery table on callback:" + e.getMessage();
            log.error(errMsg);
            throw new BQTableUpdateFailure(errMsg, e);
        }
    }

    @Override
    public void updateSchema() {
        this.onSchemaUpdate(null);
    }

    private void addMetadataFields(List<Field> bqSchemaFields) {
        List duplicateFields;
        ArrayList<Field> bqMetadataFields = new ArrayList<Field>();
        String namespaceName = this.config.getBqMetadataNamespace();
        if (this.config.shouldAddMetadata()) {
            List<TupleString> metadataColumnsTypes = this.config.getMetadataColumnsTypes();
            if (namespaceName.isEmpty()) {
                bqMetadataFields.addAll(BigqueryFields.getMetadataFields(metadataColumnsTypes));
            } else {
                bqMetadataFields.add(BigqueryFields.getNamespacedMetadataField(namespaceName, metadataColumnsTypes));
            }
        }
        if ((duplicateFields = this.getDuplicateFields(bqSchemaFields, bqMetadataFields).stream().map(Field::getName).collect(Collectors.toList())).size() > 0) {
            throw new BQSchemaMappingException(String.format("Metadata field(s) is already present in the schema. fields: %s", duplicateFields));
        }
        bqSchemaFields.addAll(bqMetadataFields);
    }

    public void close() throws IOException {
    }

    private List<Field> getDuplicateFields(List<Field> fields1, List<Field> fields2) {
        return fields1.stream().filter(field -> this.containsField(fields2, field.getName())).collect(Collectors.toList());
    }

    private boolean containsField(List<Field> fields, String fieldName) {
        return fields.stream().anyMatch(field -> field.getName().equals(fieldName));
    }

    public MessageRecordConverterCache getConverterCache() {
        return this.converterCache;
    }
}

