/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.storage;

import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.RowError;
import com.google.rpc.Code;
import com.google.rpc.Status;
import com.gotocompany.depot.SinkResponse;
import com.gotocompany.depot.bigquery.storage.BigQueryPayload;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.metrics.BigQueryMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import io.grpc.Status;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class BigQueryStorageResponseParser {
    private static final Set<Status.Code> RETRYABLE_ERROR_CODES = new HashSet<Status.Code>(){
        {
            this.add(Status.Code.INTERNAL);
            this.add(Status.Code.ABORTED);
            this.add(Status.Code.CANCELLED);
            this.add(Status.Code.FAILED_PRECONDITION);
            this.add(Status.Code.DEADLINE_EXCEEDED);
            this.add(Status.Code.UNAVAILABLE);
        }
    };
    private final BigQuerySinkConfig sinkConfig;
    private final Instrumentation instrumentation;
    private final BigQueryMetrics bigQueryMetrics;

    public BigQueryStorageResponseParser(BigQuerySinkConfig sinkConfig, Instrumentation instrumentation, BigQueryMetrics bigQueryMetrics) {
        this.sinkConfig = sinkConfig;
        this.instrumentation = instrumentation;
        this.bigQueryMetrics = bigQueryMetrics;
    }

    public static ErrorInfo getError(Status error) {
        Code code = Code.forNumber((int)error.getCode());
        switch (code) {
            case OK: {
                return null;
            }
            case CANCELLED: 
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case ALREADY_EXISTS: 
            case PERMISSION_DENIED: 
            case UNAUTHENTICATED: 
            case RESOURCE_EXHAUSTED: 
            case FAILED_PRECONDITION: 
            case ABORTED: 
            case OUT_OF_RANGE: {
                return new ErrorInfo(new Exception(error.getMessage()), ErrorType.SINK_4XX_ERROR);
            }
            case UNKNOWN: 
            case INTERNAL: 
            case DATA_LOSS: 
            case UNAVAILABLE: 
            case UNIMPLEMENTED: 
            case UNRECOGNIZED: 
            case DEADLINE_EXCEEDED: {
                return new ErrorInfo(new Exception(error.getMessage()), ErrorType.SINK_5XX_ERROR);
            }
        }
        return new ErrorInfo(new Exception(error.getMessage()), ErrorType.SINK_UNKNOWN_ERROR);
    }

    public static boolean shouldRetry(io.grpc.Status status) {
        return RETRYABLE_ERROR_CODES.contains(status.getCode());
    }

    public static ErrorInfo get4xxError(RowError rowError) {
        return new ErrorInfo(new Exception(rowError.getMessage()), ErrorType.SINK_4XX_ERROR);
    }

    public static AppendRowsResponse get4xxErrorResponse() {
        return AppendRowsResponse.newBuilder().setError(Status.newBuilder().setCode(Code.FAILED_PRECONDITION.ordinal()).build()).build();
    }

    public void setSinkResponseForInvalidMessages(BigQueryPayload payload, List<Message> messages, SinkResponse sinkResponse) {
        payload.forEach(meta -> {
            if (!meta.isValid()) {
                sinkResponse.addErrors(meta.getInputIndex(), meta.getErrorInfo());
                this.instrumentation.logError("Error {} occurred while converting to payload for record {}", meta.getErrorInfo(), ((Message)messages.get((int)meta.getInputIndex())).getMetadataString());
            }
        });
    }

    private void instrumentErrors(Object error) {
        this.instrumentation.incrementCounter(this.bigQueryMetrics.getBigqueryTotalErrorsMetrics(), String.format("table=%s", this.sinkConfig.getTableName()), String.format("dataset=%s", this.sinkConfig.getDatasetName()), String.format("project=%s", this.sinkConfig.getGCloudProjectID()), String.format("error=%s", error.toString()));
    }

    public void setSinkResponseForErrors(BigQueryPayload payload, AppendRowsResponse appendRowsResponse, List<Message> messages, SinkResponse sinkResponse) {
        if (appendRowsResponse.hasError()) {
            this.instrumentation.logError("received an error in stream :{} ", appendRowsResponse.getError());
            Status error = appendRowsResponse.getError();
            ErrorInfo errorInfo = BigQueryStorageResponseParser.getError(error);
            Set<Long> payloadIndexes = payload.getPayloadIndexes();
            Code code = Code.forNumber((int)error.getCode());
            payloadIndexes.forEach(index -> {
                long inputIndex = payload.getInputIndex((long)index);
                sinkResponse.addErrors(inputIndex, errorInfo);
                this.instrumentErrors(code);
            });
        }
        List rowErrorsList = appendRowsResponse.getRowErrorsList();
        rowErrorsList.forEach(rowError -> {
            ErrorInfo errorInfo = BigQueryStorageResponseParser.get4xxError(rowError);
            long inputIndex = payload.getInputIndex(rowError.getIndex());
            sinkResponse.addErrors(inputIndex, errorInfo);
            String metadataString = ((Message)messages.get((int)inputIndex)).getMetadataString();
            this.instrumentation.logError("Error {} occurred while sending the payload for record {} with RowError {}", errorInfo, metadataString, rowError);
            this.instrumentErrors(rowError.getCode());
        });
    }

    public void setSinkResponseForException(Throwable cause, BigQueryPayload payload, List<Message> messages, SinkResponse sinkResponse) {
        io.grpc.Status status = io.grpc.Status.fromThrowable((Throwable)cause);
        this.instrumentation.logError("Error from exception: {} ", status);
        if (cause instanceof Exceptions.AppendSerializationError) {
            IntStream.range(0, payload.getPayloadIndexes().size()).forEach(index -> {
                sinkResponse.addErrors(payload.getInputIndex(index), new ErrorInfo(new Exception(cause), ErrorType.SINK_5XX_ERROR));
                this.instrumentErrors(status.getCode());
            });
            Exceptions.AppendSerializationError ase = (Exceptions.AppendSerializationError)cause;
            Map rowIndexToErrorMessage = ase.getRowIndexToErrorMessage();
            rowIndexToErrorMessage.forEach((index, err) -> {
                long inputIndex = payload.getInputIndex(index.intValue());
                String metadataString = ((Message)messages.get((int)inputIndex)).getMetadataString();
                ErrorInfo errorInfo = new ErrorInfo(new Exception((String)err), ErrorType.SINK_4XX_ERROR);
                this.instrumentation.logError("Error {} occurred while sending the payload for record {}", errorInfo, metadataString);
                sinkResponse.addErrors(inputIndex, errorInfo);
                this.instrumentErrors((Object)BigQueryMetrics.BigQueryStorageAPIError.ROW_APPEND_ERROR);
            });
        } else if (BigQueryStorageResponseParser.shouldRetry(status)) {
            IntStream.range(0, payload.getPayloadIndexes().size()).forEach(index -> {
                sinkResponse.addErrors(payload.getInputIndex(index), new ErrorInfo(new Exception(cause), ErrorType.SINK_5XX_ERROR));
                this.instrumentErrors(status.getCode());
            });
        } else {
            IntStream.range(0, payload.getPayloadIndexes().size()).forEach(index -> {
                sinkResponse.addErrors(payload.getInputIndex(index), new ErrorInfo(new Exception(cause), ErrorType.SINK_4XX_ERROR));
                this.instrumentErrors(status.getCode());
            });
        }
    }
}

