/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.storage.proto;

import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.gotocompany.depot.bigquery.storage.BigQueryPayload;
import com.gotocompany.depot.bigquery.storage.BigQueryStorageClient;
import com.gotocompany.depot.bigquery.storage.BigQueryWriter;
import com.gotocompany.depot.bigquery.storage.proto.BigQueryProtoUtils;
import com.gotocompany.depot.bigquery.storage.proto.BigQueryProtoWriter;
import com.gotocompany.depot.bigquery.storage.proto.BigQueryRecordMeta;
import com.gotocompany.depot.bigquery.storage.proto.TimeStampUtils;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.exception.UnknownFieldsException;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.ProtoUnknownFieldValidationType;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.message.proto.converter.fields.DurationProtoField;
import com.gotocompany.depot.message.proto.converter.fields.MessageProtoField;
import com.gotocompany.depot.message.proto.converter.fields.ProtoField;
import com.gotocompany.depot.message.proto.converter.fields.ProtoFieldFactory;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BigQueryProtoStorageClient
implements BigQueryStorageClient {
    private static final long MESSAGE_PARSER_CHECKER_DELAY_SECONDS = 1L;
    private static final long MESSAGE_PARSER_CHECKER_FREQUENCY_SECONDS = 60L;
    private final BigQueryProtoWriter writer;
    private final BigQuerySinkConfig config;
    private final MessageParser parser;
    private final String schemaClass;
    private final SinkConnectorSchemaMessageMode mode;
    private final ScheduledExecutorService messageParserChecker = Executors.newScheduledThreadPool(1);
    private final ProtoUnknownFieldValidationType protoUnknownFieldValidationType;
    private final boolean sinkConnectorSchemaProtoAllowUnknownFieldsEnable;

    public BigQueryProtoStorageClient(BigQueryWriter writer, BigQuerySinkConfig config, MessageParser parser) {
        this.writer = (BigQueryProtoWriter)writer;
        this.config = config;
        this.parser = parser;
        this.mode = config.getSinkConnectorSchemaMessageMode();
        this.schemaClass = this.mode == SinkConnectorSchemaMessageMode.LOG_MESSAGE ? config.getSinkConnectorSchemaProtoMessageClass() : config.getSinkConnectorSchemaProtoKeyClass();
        this.messageParserChecker.scheduleWithFixedDelay(() -> parser.refresh(this.schemaClass), 1L, 60L, TimeUnit.SECONDS);
        this.protoUnknownFieldValidationType = config.getSinkConnectorSchemaProtoUnknownFieldsValidation();
        this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable = config.getSinkConnectorSchemaProtoAllowUnknownFieldsEnable();
    }

    @Override
    public BigQueryPayload convert(List<Message> messages) {
        ProtoRows.Builder rowBuilder = ProtoRows.newBuilder();
        BigQueryPayload payload = new BigQueryPayload();
        this.writer.checkAndRefreshConnection();
        Descriptors.Descriptor descriptor = this.writer.getDescriptor();
        long validIndex = 0L;
        for (int index = 0; index < messages.size(); ++index) {
            BigQueryRecordMeta metadata;
            ErrorInfo errorInfo;
            Message message = messages.get(index);
            try {
                DynamicMessage convertedMessage = this.convert(message, descriptor);
                BigQueryRecordMeta metadata2 = new BigQueryRecordMeta(index, null, true);
                payload.addMetadataRecord(metadata2);
                payload.putValidIndexToInputIndex(validIndex++, index);
                rowBuilder.addSerializedRows(convertedMessage.toByteString());
                continue;
            }
            catch (UnknownFieldsException e) {
                errorInfo = new ErrorInfo(e, ErrorType.UNKNOWN_FIELDS_ERROR);
                metadata = new BigQueryRecordMeta(index, errorInfo, false);
                payload.addMetadataRecord(metadata);
                continue;
            }
            catch (EmptyMessageException | UnsupportedOperationException e) {
                errorInfo = new ErrorInfo(e, ErrorType.INVALID_MESSAGE_ERROR);
                metadata = new BigQueryRecordMeta(index, errorInfo, false);
                payload.addMetadataRecord(metadata);
                continue;
            }
            catch (DeserializerException | IOException | IllegalArgumentException e) {
                errorInfo = new ErrorInfo(e, ErrorType.DESERIALIZATION_ERROR);
                metadata = new BigQueryRecordMeta(index, errorInfo, false);
                payload.addMetadataRecord(metadata);
                continue;
            }
            catch (Exception e) {
                errorInfo = new ErrorInfo(e, ErrorType.SINK_UNKNOWN_ERROR);
                metadata = new BigQueryRecordMeta(index, errorInfo, false);
                payload.addMetadataRecord(metadata);
            }
        }
        payload.setPayload(rowBuilder.build());
        return payload;
    }

    @Override
    public AppendRowsResponse appendAndGet(BigQueryPayload payload) throws ExecutionException, InterruptedException {
        return this.writer.appendAndGet(payload);
    }

    private DynamicMessage convert(Message message, Descriptors.Descriptor descriptor) throws IOException {
        ParsedMessage parsedMessage = this.parser.parse(message, this.mode, this.schemaClass);
        if (!this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable) {
            parsedMessage.validate(this.protoUnknownFieldValidationType);
        }
        DynamicMessage.Builder messageBuilder = this.convert((DynamicMessage)parsedMessage.getRaw(), descriptor, true);
        BigQueryProtoUtils.addMetadata(message.getMetadata(), messageBuilder, descriptor, this.config);
        return messageBuilder.build();
    }

    private DynamicMessage.Builder convert(DynamicMessage inputMessage, Descriptors.Descriptor descriptor, boolean isTopLevel) {
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        List allFields = inputMessage.getDescriptorForType().getFields();
        for (Descriptors.FieldDescriptor inputField : allFields) {
            Descriptors.FieldDescriptor outputField = descriptor.findFieldByName(inputField.getName().toLowerCase());
            if (outputField == null) continue;
            ProtoField protoField = ProtoFieldFactory.getField(inputField, inputMessage.getField(inputField));
            Object fieldValue = protoField.getValue();
            if (fieldValue instanceof List) {
                this.addRepeatedFields(messageBuilder, outputField, (List)fieldValue);
                continue;
            }
            if (fieldValue.toString().isEmpty()) continue;
            if (fieldValue instanceof Instant) {
                if (((Instant)fieldValue).getEpochSecond() <= 0L) continue;
                long timeStampValue = TimeStampUtils.getBQInstant((Instant)fieldValue, outputField, isTopLevel, this.config);
                messageBuilder.setField(outputField, (Object)timeStampValue);
                continue;
            }
            if (protoField.getClass().getName().equals(MessageProtoField.class.getName()) || protoField.getClass().getName().equals(DurationProtoField.class.getName())) {
                Descriptors.Descriptor messageType = outputField.getMessageType();
                messageBuilder.setField(outputField, (Object)this.convert((DynamicMessage)fieldValue, messageType, false).build());
                continue;
            }
            messageBuilder.setField(outputField, fieldValue);
        }
        return messageBuilder;
    }

    private void addRepeatedFields(DynamicMessage.Builder messageBuilder, Descriptors.FieldDescriptor outputField, List<?> fieldValue) {
        if (fieldValue.isEmpty()) {
            return;
        }
        ArrayList<Object> repeatedNestedFields = new ArrayList<Object>();
        for (Object f : fieldValue) {
            if (f instanceof DynamicMessage) {
                Descriptors.Descriptor messageType = outputField.getMessageType();
                repeatedNestedFields.add(this.convert((DynamicMessage)f, messageType, false).build());
                continue;
            }
            if (f instanceof Instant) {
                if (((Instant)f).getEpochSecond() <= 0L) continue;
                repeatedNestedFields.add(TimeStampUtils.getBQInstant((Instant)f, outputField, false, this.config));
                continue;
            }
            repeatedNestedFields.add(f);
        }
        messageBuilder.setField(outputField, repeatedNestedFields);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.messageParserChecker.shutdownNow();
    }
}

