/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.storage.proto;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamView;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.bigquery.storage.BigQueryPayload;
import com.gotocompany.depot.bigquery.storage.BigQueryStorageResponseParser;
import com.gotocompany.depot.bigquery.storage.BigQueryStream;
import com.gotocompany.depot.bigquery.storage.BigQueryWriter;
import com.gotocompany.depot.bigquery.storage.BigQueryWriterUtils;
import com.gotocompany.depot.bigquery.storage.proto.BigQueryProtoStream;
import com.gotocompany.depot.common.Function3;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.metrics.BigQueryMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class BigQueryProtoWriter
implements BigQueryWriter {
    private static final int INTERNAL_CONNECTION_TIMEOUT = 10;
    private final BigQuerySinkConfig config;
    private final Function<BigQuerySinkConfig, BigQueryWriteClient> bqWriterCreator;
    private final Function<BigQuerySinkConfig, CredentialsProvider> credCreator;
    private final Function3<BigQuerySinkConfig, CredentialsProvider, ProtoSchema, BigQueryStream> streamCreator;
    private final Instrumentation instrumentation;
    private final BigQueryMetrics metrics;
    private StreamWriter streamWriter;
    private Descriptors.Descriptor descriptor;
    private ProtoSchema schema;
    private boolean isClosed = false;
    private long lastAppendTimeStamp;

    public BigQueryProtoWriter(BigQuerySinkConfig config, Function<BigQuerySinkConfig, BigQueryWriteClient> bqWriterCreator, Function<BigQuerySinkConfig, CredentialsProvider> credCreator, Function3<BigQuerySinkConfig, CredentialsProvider, ProtoSchema, BigQueryStream> streamCreator, Instrumentation instrumentation, BigQueryMetrics metrics) {
        this.config = config;
        this.bqWriterCreator = bqWriterCreator;
        this.credCreator = credCreator;
        this.streamCreator = streamCreator;
        this.instrumentation = instrumentation;
        this.metrics = metrics;
    }

    @Override
    public void init() {
        try {
            String streamName = BigQueryWriterUtils.getDefaultStreamName(this.config);
            GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(streamName).setView(WriteStreamView.FULL).build();
            try (BigQueryWriteClient bigQueryInstance = this.bqWriterCreator.apply(this.config);){
                WriteStream writeStream = bigQueryInstance.getWriteStream(writeStreamRequest);
                this.createAndSetStreamWriter(writeStream.getTableSchema());
            }
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalArgumentException("Could not initialise the bigquery writer", e);
        }
    }

    private void createAndSetStreamWriter(TableSchema updatedSchema) throws Descriptors.DescriptorValidationException {
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)updatedSchema);
        this.schema = ProtoSchemaConverter.convert((Descriptors.Descriptor)this.descriptor);
        this.streamWriter = this.createStreamWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BigQueryProtoWriter bigQueryProtoWriter = this;
        synchronized (bigQueryProtoWriter) {
            this.isClosed = true;
            this.instrumentation.logInfo("Closing StreamWriter", new Object[0]);
            Instant start = Instant.now();
            this.streamWriter.close();
            this.instrument(start, BigQueryMetrics.BigQueryStorageAPIType.STREAM_WRITER_CLOSED);
        }
    }

    @Override
    public AppendRowsResponse appendAndGet(BigQueryPayload rows) throws ExecutionException, InterruptedException {
        if (this.isClosed) {
            this.instrumentation.logError("The client is permanently closed. More tasks can not be added", new Object[0]);
            return BigQueryStorageResponseParser.get4xxErrorResponse();
        }
        ProtoRows payload = (ProtoRows)rows.getPayload();
        Instant start = Instant.now();
        this.lastAppendTimeStamp = System.nanoTime();
        ApiFuture future = this.streamWriter.append(payload);
        AppendRowsResponse appendRowsResponse = (AppendRowsResponse)future.get();
        this.instrument(start, BigQueryMetrics.BigQueryStorageAPIType.STREAM_WRITER_APPEND);
        this.captureSizeMetric(payload);
        return appendRowsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndRefreshConnection() {
        BigQueryProtoWriter bigQueryProtoWriter = this;
        synchronized (bigQueryProtoWriter) {
            if (this.streamWriter == null || this.streamWriter.isClosed() || this.checkInactiveConnection()) {
                this.instrumentation.logInfo("Recreating stream writer, because it was closed with exception or abandoned by the server", new Object[0]);
                this.closeStreamWriter();
                this.init();
            } else {
                TableSchema updatedSchema = this.streamWriter.getUpdatedSchema();
                if (updatedSchema != null) {
                    this.instrumentation.logInfo("Updated table schema detected, recreating stream writer", new Object[0]);
                    try {
                        this.closeStreamWriter();
                        this.createAndSetStreamWriter(updatedSchema);
                    }
                    catch (Descriptors.DescriptorValidationException e) {
                        throw new IllegalArgumentException("Could not initialise the bigquery writer", e);
                    }
                }
            }
        }
    }

    private void closeStreamWriter() {
        if (this.streamWriter != null) {
            Instant start = Instant.now();
            this.streamWriter.close();
            this.instrument(start, BigQueryMetrics.BigQueryStorageAPIType.STREAM_WRITER_CLOSED);
        }
    }

    private boolean checkInactiveConnection() {
        return System.nanoTime() - this.lastAppendTimeStamp >= TimeUnit.MINUTES.toNanos(10L);
    }

    private StreamWriter createStreamWriter() {
        Instant start = Instant.now();
        this.lastAppendTimeStamp = System.nanoTime();
        BigQueryStream bigQueryStream = this.streamCreator.apply(this.config, this.credCreator.apply(this.config), this.schema);
        this.instrumentation.logInfo("Creating bq write stream with schema {}", this.schema);
        this.instrument(start, BigQueryMetrics.BigQueryStorageAPIType.STREAM_WRITER_CREATED);
        assert (bigQueryStream instanceof BigQueryProtoStream);
        return ((BigQueryProtoStream)bigQueryStream).getStreamWriter();
    }

    private void captureSizeMetric(ProtoRows payload) {
        this.instrumentation.captureCount(this.metrics.getBigqueryPayloadSizeMetrics(), Long.valueOf(payload.getSerializedSize()), String.format("table=%s", this.config.getTableName()), String.format("dataset=%s", this.config.getDatasetName()), String.format("project=%s", this.config.getGCloudProjectID()));
    }

    private void instrument(Instant start, BigQueryMetrics.BigQueryStorageAPIType type) {
        this.instrumentation.incrementCounter(this.metrics.getBigqueryOperationTotalMetric(), String.format("table=%s", this.config.getTableName()), String.format("dataset=%s", this.config.getDatasetName()), String.format("project=%s", this.config.getGCloudProjectID()), String.format("api=%s", new Object[]{type}));
        this.instrumentation.captureDurationSince(this.metrics.getBigqueryOperationLatencyMetric(), start, String.format("table=%s", this.config.getTableName()), String.format("dataset=%s", this.config.getDatasetName()), String.format("project=%s", this.config.getGCloudProjectID()), String.format("api=%s", new Object[]{type}));
    }

    public StreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }
}

