/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigtable.parser;

import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.gotocompany.depot.bigtable.model.BigTableRecord;
import com.gotocompany.depot.bigtable.model.BigTableSchema;
import com.gotocompany.depot.bigtable.parser.BigTableRowKeyParser;
import com.gotocompany.depot.common.Tuple;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableRecordParser {
    private static final Logger log = LoggerFactory.getLogger(BigTableRecordParser.class);
    private final MessageParser messageParser;
    private final BigTableRowKeyParser bigTableRowKeyParser;
    private final BigTableSchema bigTableSchema;
    private final Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema;

    public BigTableRecordParser(MessageParser messageParser, BigTableRowKeyParser bigTableRowKeyParser, Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema, BigTableSchema bigTableSchema) {
        this.messageParser = messageParser;
        this.bigTableRowKeyParser = bigTableRowKeyParser;
        this.modeAndSchema = modeAndSchema;
        this.bigTableSchema = bigTableSchema;
    }

    public List<BigTableRecord> convert(List<Message> messages) {
        ArrayList<BigTableRecord> records = new ArrayList<BigTableRecord>();
        for (int index = 0; index < messages.size(); ++index) {
            Message message = messages.get(index);
            BigTableRecord record = this.createRecord(message, index);
            records.add(record);
        }
        return records;
    }

    private BigTableRecord createRecord(Message message, long index) {
        try {
            ParsedMessage parsedMessage = this.messageParser.parse(message, this.modeAndSchema.getFirst(), this.modeAndSchema.getSecond());
            String rowKey = this.bigTableRowKeyParser.parse(parsedMessage);
            RowMutationEntry rowMutationEntry = RowMutationEntry.create((String)rowKey);
            this.bigTableSchema.getColumnFamilies().forEach(columnFamily -> this.bigTableSchema.getColumns((String)columnFamily).forEach(column -> {
                String fieldName = this.bigTableSchema.getField((String)columnFamily, (String)column);
                String value = parsedMessage.getFieldByName(fieldName).toString();
                rowMutationEntry.setCell(columnFamily, column, value);
            }));
            BigTableRecord bigTableRecord = new BigTableRecord(rowMutationEntry, index, null, message.getMetadata());
            if (log.isDebugEnabled()) {
                log.debug(bigTableRecord.toString());
            }
            return bigTableRecord;
        }
        catch (EmptyMessageException e) {
            return this.createErrorRecord(e, ErrorType.INVALID_MESSAGE_ERROR, index, message.getMetadata());
        }
        catch (ConfigurationException | IllegalArgumentException e) {
            return this.createErrorRecord(e, ErrorType.UNKNOWN_FIELDS_ERROR, index, message.getMetadata());
        }
        catch (DeserializerException | IOException e) {
            return this.createErrorRecord(e, ErrorType.DESERIALIZATION_ERROR, index, message.getMetadata());
        }
    }

    private BigTableRecord createErrorRecord(Exception e, ErrorType type, long index, Map<String, Object> metadata) {
        ErrorInfo errorInfo = new ErrorInfo(e, type);
        return new BigTableRecord(null, index, errorInfo, metadata);
    }
}

