/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config;

import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.config.converter.ConfToListConverter;
import com.gotocompany.depot.config.converter.LabelMapConverter;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Config;

public interface BigQuerySinkConfig
extends SinkConfig {
    @Config.Key(value="SINK_BIGQUERY_GOOGLE_CLOUD_PROJECT_ID")
    public String getGCloudProjectID();

    @Config.Key(value="SINK_BIGQUERY_TABLE_NAME")
    public String getTableName();

    @Config.Key(value="SINK_BIGQUERY_DATASET_LABELS")
    @Config.Separator(value=",")
    @Config.ConverterClass(value=LabelMapConverter.class)
    public Map<String, String> getDatasetLabels();

    @Config.Key(value="SINK_BIGQUERY_TABLE_LABELS")
    @Config.Separator(value=",")
    @Config.ConverterClass(value=LabelMapConverter.class)
    public Map<String, String> getTableLabels();

    @Config.Key(value="SINK_BIGQUERY_DATASET_NAME")
    public String getDatasetName();

    @Config.Key(value="SINK_BIGQUERY_CREDENTIAL_PATH")
    public String getBigQueryCredentialPath();

    @Config.Key(value="SINK_BIGQUERY_TABLE_PARTITIONING_ENABLE")
    @Config.DefaultValue(value="false")
    public Boolean isTablePartitioningEnabled();

    @Config.Key(value="SINK_BIGQUERY_TABLE_PARTITION_KEY")
    public String getTablePartitionKey();

    @Config.Key(value="SINK_BIGQUERY_TABLE_CLUSTERING_ENABLE")
    @Config.DefaultValue(value="false")
    public Boolean isTableClusteringEnabled();

    @Config.Key(value="SINK_BIGQUERY_TABLE_CLUSTERING_KEYS")
    @Config.Separator(value=",")
    public List<String> getTableClusteringKeys();

    @Config.Key(value="SINK_BIGQUERY_ROW_INSERT_ID_ENABLE")
    @Config.DefaultValue(value="true")
    public Boolean isRowInsertIdEnabled();

    @Config.Key(value="SINK_BIGQUERY_CLIENT_READ_TIMEOUT_MS")
    @Config.DefaultValue(value="-1")
    public int getBqClientReadTimeoutMS();

    @Config.Key(value="SINK_BIGQUERY_CLIENT_CONNECT_TIMEOUT_MS")
    @Config.DefaultValue(value="-1")
    public int getBqClientConnectTimeoutMS();

    @Config.Key(value="SINK_BIGQUERY_TABLE_PARTITION_EXPIRY_MS")
    @Config.DefaultValue(value="-1")
    public Long getBigQueryTablePartitionExpiryMS();

    @Config.Key(value="SINK_BIGQUERY_DATASET_LOCATION")
    @Config.DefaultValue(value="asia-southeast1")
    public String getBigQueryDatasetLocation();

    @Config.Key(value="SINK_BIGQUERY_METADATA_NAMESPACE")
    @Config.DefaultValue(value="")
    public String getBqMetadataNamespace();

    @Override
    @Config.DefaultValue(value="true")
    @Config.Key(value="SINK_BIGQUERY_ADD_METADATA_ENABLED")
    public boolean shouldAddMetadata();

    @Override
    @Config.DefaultValue(value="")
    @Config.Key(value="SINK_BIGQUERY_METADATA_COLUMNS_TYPES")
    @Config.ConverterClass(value=ConfToListConverter.class)
    @Config.Separator(value=",")
    public List<TupleString> getMetadataColumnsTypes();

    @Config.DefaultValue(value="false")
    @Config.Key(value="SINK_BIGQUERY_ADD_EVENT_TIMESTAMP_ENABLE")
    public boolean getSinkBigqueryAddEventTimestampEnable();

    @Config.DefaultValue(value="")
    @Config.Key(value="SINK_BIGQUERY_DEFAULT_COLUMNS")
    @Config.ConverterClass(value=ConfToListConverter.class)
    @Config.Separator(value=",")
    public List<TupleString> getSinkBigqueryDefaultColumns();

    @Config.DefaultValue(value="true")
    @Config.Key(value="SINK_BIGQUERY_DEFAULT_DATATYPE_STRING_ENABLE")
    public boolean getSinkBigqueryDefaultDatatypeStringEnable();

    @Config.DefaultValue(value="true")
    @Config.Key(value="SINK_BIGQUERY_DYNAMIC_SCHEMA_ENABLE")
    public boolean getSinkBigqueryDynamicSchemaEnable();

    @Config.DefaultValue(value="false")
    @Config.Key(value="SINK_BIGQUERY_STORAGE_API_ENABLE")
    public boolean getSinkBigqueryStorageAPIEnable();
}

