/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config.converter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.aeonbits.owner.Converter;

public class JsonToPropertiesConverter
implements Converter<Properties> {
    private static final Gson GSON = new Gson();

    public Properties convert(Method method, String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return null;
        }
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map m = (Map)GSON.fromJson(input, type);
        Properties properties = this.getProperties(m);
        this.validate(properties);
        return properties;
    }

    private Properties getProperties(Map<String, Object> inputMap) {
        Properties properties = new Properties();
        for (String key : inputMap.keySet()) {
            Object value = inputMap.get(key);
            if (value instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            properties.put(key, this.getProperties((Map)value));
        }
        return properties;
    }

    private void validate(Properties properties) {
        DuplicateFinder duplicateFinder = this.flattenValues(properties).collect(() -> new DuplicateFinder(), DuplicateFinder::accept, DuplicateFinder::combine);
        if (duplicateFinder.duplicates.size() > 0) {
            throw new IllegalArgumentException("duplicates found in SINK_REDIS_HASHSET_FIELD_TO_COLUMN_MAPPING for : " + duplicateFinder.duplicates);
        }
    }

    private Stream<String> flattenValues(Properties properties) {
        return properties.values().stream().flatMap(v -> {
            if (v instanceof String) {
                return Stream.of((String)v);
            }
            if (v instanceof Properties) {
                return this.flattenValues((Properties)v);
            }
            return Stream.empty();
        });
    }

    private static class DuplicateFinder
    implements Consumer<String> {
        private final Set<String> processedValues = new HashSet<String>();
        private final List<String> duplicates = new ArrayList<String>();

        private DuplicateFinder() {
        }

        @Override
        public void accept(String o) {
            if (this.processedValues.contains(o)) {
                this.duplicates.add(o);
            } else {
                this.processedValues.add(o);
            }
        }

        void combine(DuplicateFinder other) {
            other.processedValues.forEach(v -> {
                if (this.processedValues.contains(v)) {
                    this.duplicates.add((String)v);
                } else {
                    this.processedValues.add((String)v);
                }
            });
        }
    }
}

