/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config.converter;

import com.google.common.base.Strings;
import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.exception.InvalidTemplateException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aeonbits.owner.Converter;
import org.json.JSONObject;

public class TemplateMapConverter
implements Converter<Map<Template, Template>> {
    public Map<Template, Template> convert(Method method, String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return Collections.emptyMap();
        }
        JSONObject jsonObject = new JSONObject(input);
        HashMap<Template, Template> templateMap = new HashMap<Template, Template>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                templateMap.put(new Template(key), new Template(jsonObject.get(key).toString()));
            }
            catch (InvalidTemplateException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return templateMap;
    }
}

