/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request.body;

import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.http.enums.HttpRequestBodyType;
import com.gotocompany.depot.http.request.body.JsonBody;
import com.gotocompany.depot.http.request.body.MessageBody;
import com.gotocompany.depot.http.request.body.RawBody;
import com.gotocompany.depot.http.request.body.RequestBody;
import com.gotocompany.depot.http.request.body.TemplatizedJsonBody;

public class RequestBodyFactory {
    public static RequestBody create(HttpSinkConfig config) {
        HttpRequestBodyType bodyType = config.getRequestBodyType();
        switch (bodyType) {
            case JSON: {
                return new JsonBody(config);
            }
            case MESSAGE: {
                return new MessageBody(config);
            }
            case TEMPLATIZED_JSON: {
                return new TemplatizedJsonBody(config);
            }
        }
        return new RawBody(config);
    }
}

