/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.client.insert;

import com.aliyun.odps.exceptions.SchemaMismatchException;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.exception.NonRetryableException;
import com.gotocompany.depot.maxcompute.client.insert.session.StreamingSessionManager;
import com.gotocompany.depot.maxcompute.model.RecordWrapper;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertManager {
    private static final Logger log = LoggerFactory.getLogger(InsertManager.class);
    private final MaxComputeSinkConfig maxComputeSinkConfig;
    private final Instrumentation instrumentation;
    private final MaxComputeMetrics maxComputeMetrics;
    private final StreamingSessionManager streamingSessionManager;
    private final TableTunnel.FlushOption flushOption;

    protected InsertManager(MaxComputeSinkConfig maxComputeSinkConfig, Instrumentation instrumentation, MaxComputeMetrics maxComputeMetrics, StreamingSessionManager streamingSessionManager) {
        this.maxComputeSinkConfig = maxComputeSinkConfig;
        this.instrumentation = instrumentation;
        this.maxComputeMetrics = maxComputeMetrics;
        this.streamingSessionManager = streamingSessionManager;
        this.flushOption = new TableTunnel.FlushOption().timeout(maxComputeSinkConfig.getMaxComputeRecordPackFlushTimeoutMs().longValue());
    }

    public abstract void insert(List<RecordWrapper> var1) throws TunnelException, IOException;

    protected TableTunnel.StreamRecordPack newRecordPack(TableTunnel.StreamUploadSession streamUploadSession) throws IOException, TunnelException {
        if (!this.maxComputeSinkConfig.isStreamingInsertCompressEnabled()) {
            return streamUploadSession.newRecordPack();
        }
        return streamUploadSession.newRecordPack(new CompressOption(this.maxComputeSinkConfig.getMaxComputeCompressionAlgorithm(), this.maxComputeSinkConfig.getMaxComputeCompressionLevel(), this.maxComputeSinkConfig.getMaxComputeCompressionStrategy()));
    }

    private void instrument(Instant start, TableTunnel.FlushResult flushResult) {
        this.instrumentation.incrementCounter(this.maxComputeMetrics.getMaxComputeOperationTotalMetric(), String.format("api=%s", new Object[]{MaxComputeMetrics.MaxComputeAPIType.TABLE_INSERT}));
        this.instrumentation.captureDurationSince(this.maxComputeMetrics.getMaxComputeOperationLatencyMetric(), start, String.format("api=%s", new Object[]{MaxComputeMetrics.MaxComputeAPIType.TABLE_INSERT}));
        this.instrumentation.captureCount(this.maxComputeMetrics.getMaxComputeFlushRecordMetric(), flushResult.getRecordCount(), String.format("compression=%s-%s", this.maxComputeSinkConfig.isStreamingInsertCompressEnabled(), this.maxComputeSinkConfig.getMaxComputeCompressionAlgorithm()));
        this.instrumentation.captureCount(this.maxComputeMetrics.getMaxComputeFlushSizeMetric(), flushResult.getFlushSize(), String.format("compression=%s-%s", this.maxComputeSinkConfig.isStreamingInsertCompressEnabled(), this.maxComputeSinkConfig.getMaxComputeCompressionAlgorithm()));
    }

    protected void appendRecord(TableTunnel.StreamRecordPack recordPack, RecordWrapper recordWrapper, String sessionKey) throws IOException {
        try {
            recordPack.append(recordWrapper.getRecord());
        }
        catch (SchemaMismatchException e) {
            log.error("Record pack schema Mismatch", (Throwable)e);
            throw new NonRetryableException("Record pack schema Mismatch", e);
        }
        catch (IOException e) {
            log.info("IOException occurs, refreshing the sessions", (Throwable)e);
            this.streamingSessionManager.refreshAllSessions();
            throw e;
        }
    }

    protected void flushRecordPack(TableTunnel.StreamRecordPack recordPack) throws IOException {
        Instant start = Instant.now();
        try {
            TableTunnel.FlushResult flushResult = recordPack.flush(this.flushOption);
            this.instrument(start, flushResult);
        }
        catch (SchemaMismatchException e) {
            log.error("Record pack schema Mismatch", (Throwable)e);
            throw new NonRetryableException("Record pack schema Mismatch", e);
        }
        catch (IOException e) {
            log.info("TunnelException occurs, refreshing the sessions", (Throwable)e);
            this.streamingSessionManager.refreshAllSessions();
            throw e;
        }
    }

    public MaxComputeSinkConfig getMaxComputeSinkConfig() {
        return this.maxComputeSinkConfig;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public MaxComputeMetrics getMaxComputeMetrics() {
        return this.maxComputeMetrics;
    }

    public StreamingSessionManager getStreamingSessionManager() {
        return this.streamingSessionManager;
    }

    public TableTunnel.FlushOption getFlushOption() {
        return this.flushOption;
    }
}

