/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.client.insert;

import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.gotocompany.depot.config.MaxComputeSinkConfig;
import com.gotocompany.depot.maxcompute.client.insert.InsertManager;
import com.gotocompany.depot.maxcompute.client.insert.session.StreamingSessionManager;
import com.gotocompany.depot.maxcompute.model.RecordWrapper;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPartitionedInsertManager
extends InsertManager {
    private static final Logger log = LoggerFactory.getLogger(NonPartitionedInsertManager.class);
    private static final String NON_PARTITIONED = "non-partitioned";

    public NonPartitionedInsertManager(MaxComputeSinkConfig maxComputeSinkConfig, Instrumentation instrumentation, MaxComputeMetrics maxComputeMetrics, StreamingSessionManager streamingSessionManager) {
        super(maxComputeSinkConfig, instrumentation, maxComputeMetrics, streamingSessionManager);
    }

    @Override
    public void insert(List<RecordWrapper> recordWrappers) throws TunnelException, IOException {
        TableTunnel.StreamUploadSession streamUploadSession = super.getStreamingSessionManager().getSession(NON_PARTITIONED);
        TableTunnel.StreamRecordPack recordPack = this.newRecordPack(streamUploadSession);
        for (RecordWrapper recordWrapper : recordWrappers) {
            super.appendRecord(recordPack, recordWrapper, NON_PARTITIONED);
        }
        super.flushRecordPack(recordPack);
    }
}

