/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.maxcompute.record;

import com.aliyun.odps.PartitionSpec;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.maxcompute.converter.ProtobufConverterOrchestrator;
import com.gotocompany.depot.maxcompute.model.ProtoPayload;
import com.gotocompany.depot.maxcompute.model.RecordWrapper;
import com.gotocompany.depot.maxcompute.record.RecordDecorator;
import com.gotocompany.depot.maxcompute.schema.partition.DefaultPartitioningStrategy;
import com.gotocompany.depot.maxcompute.schema.partition.PartitioningStrategy;
import com.gotocompany.depot.maxcompute.schema.partition.TimestampPartitioningStrategy;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.ProtoUnknownFieldValidationType;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.MaxComputeMetrics;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.utils.ProtoUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ProtoDataColumnRecordDecorator
extends RecordDecorator {
    private final ProtobufConverterOrchestrator protobufConverterOrchestrator;
    private final MessageParser protoMessageParser;
    private final PartitioningStrategy partitioningStrategy;
    private final SinkConnectorSchemaMessageMode sinkConnectorSchemaMessageMode;
    private final String partitionFieldName;
    private final boolean shouldReplaceOriginalColumn;
    private final String schemaClass;
    private final ProtoUnknownFieldValidationType protoUnknownFieldValidationType;
    private final Instrumentation instrumentation;
    private final MaxComputeMetrics maxComputeMetrics;
    private final boolean sinkConnectorSchemaProtoAllowUnknownFieldsEnable;
    private final boolean sinkConnectorSchemaProtoUnknownFieldsValidationInstrumentationEnable;

    public ProtoDataColumnRecordDecorator(RecordDecorator decorator, ProtobufConverterOrchestrator protobufConverterOrchestrator, MessageParser messageParser, SinkConfig sinkConfig, PartitioningStrategy partitioningStrategy, StatsDReporter statsDReporter, MaxComputeMetrics maxComputeMetrics) {
        super(decorator);
        this.protobufConverterOrchestrator = protobufConverterOrchestrator;
        this.protoMessageParser = messageParser;
        this.partitioningStrategy = partitioningStrategy;
        this.sinkConnectorSchemaMessageMode = sinkConfig.getSinkConnectorSchemaMessageMode();
        this.partitionFieldName = Optional.ofNullable(partitioningStrategy).map(PartitioningStrategy::getOriginalPartitionColumnName).orElse(null);
        this.shouldReplaceOriginalColumn = Optional.ofNullable(partitioningStrategy).map(PartitioningStrategy::shouldReplaceOriginalColumn).orElse(false);
        this.schemaClass = sinkConfig.getSinkConnectorSchemaMessageMode() == SinkConnectorSchemaMessageMode.LOG_MESSAGE ? sinkConfig.getSinkConnectorSchemaProtoMessageClass() : sinkConfig.getSinkConnectorSchemaProtoKeyClass();
        this.protoUnknownFieldValidationType = sinkConfig.getSinkConnectorSchemaProtoUnknownFieldsValidation();
        this.instrumentation = new Instrumentation(statsDReporter, this.getClass());
        this.maxComputeMetrics = maxComputeMetrics;
        this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable = sinkConfig.getSinkConnectorSchemaProtoAllowUnknownFieldsEnable();
        this.sinkConnectorSchemaProtoUnknownFieldsValidationInstrumentationEnable = sinkConfig.getSinkConnectorSchemaProtoUnknownFieldsValidationInstrumentationEnable();
    }

    @Override
    public RecordWrapper process(RecordWrapper recordWrapper, com.gotocompany.depot.message.Message message) throws IOException {
        ParsedMessage parsedMessage = this.protoMessageParser.parse(message, this.sinkConnectorSchemaMessageMode, this.schemaClass);
        if (!this.sinkConnectorSchemaProtoAllowUnknownFieldsEnable) {
            Instant unknownFieldValidationStart = Instant.now();
            parsedMessage.validate(this.protoUnknownFieldValidationType);
            if (this.sinkConnectorSchemaProtoUnknownFieldsValidationInstrumentationEnable) {
                this.instrumentation.captureDurationSince(this.maxComputeMetrics.getMaxComputeUnknownFieldValidationLatencyMetric(), unknownFieldValidationStart, String.format("unknown_field_validation_type=%s", new Object[]{this.protoUnknownFieldValidationType}));
            }
        }
        Message protoMessage = (Message)parsedMessage.getRaw();
        protoMessage.getDescriptorForType().getFields().forEach(fieldDescriptor -> {
            if (fieldDescriptor.getName().equals(this.partitionFieldName) && this.shouldReplaceOriginalColumn) {
                return;
            }
            if (protoMessage.getField(fieldDescriptor).toString().isEmpty()) {
                return;
            }
            if (ProtoUtils.isNonRepeatedProtoMessage(fieldDescriptor) && !protoMessage.hasField(fieldDescriptor)) {
                return;
            }
            if (ProtoUtils.isNonRepeatedString(fieldDescriptor) && !protoMessage.hasField(fieldDescriptor)) {
                return;
            }
            recordWrapper.getRecord().set(fieldDescriptor.getName(), this.protobufConverterOrchestrator.toMaxComputeValue(new ProtoPayload((Descriptors.FieldDescriptor)fieldDescriptor, protoMessage.getField(fieldDescriptor), 0)));
        });
        PartitionSpec partitionSpec = this.getPartitionSpec(recordWrapper, protoMessage);
        return new RecordWrapper(recordWrapper.getRecord(), recordWrapper.getIndex(), recordWrapper.getErrorInfo(), partitionSpec);
    }

    @Nullable
    private PartitionSpec getPartitionSpec(RecordWrapper recordWrapper, Message protoMessage) {
        PartitionSpec partitionSpec = null;
        if (this.partitioningStrategy != null && this.partitioningStrategy instanceof DefaultPartitioningStrategy) {
            Descriptors.FieldDescriptor partitionFieldDescriptor = protoMessage.getDescriptorForType().findFieldByName(this.partitioningStrategy.getOriginalPartitionColumnName());
            Object object = protoMessage.hasField(partitionFieldDescriptor) ? protoMessage.getField(protoMessage.getDescriptorForType().findFieldByName(this.partitioningStrategy.getOriginalPartitionColumnName())) : null;
            partitionSpec = this.partitioningStrategy.getPartitionSpec(object);
        }
        if (this.partitioningStrategy != null && this.partitioningStrategy instanceof TimestampPartitioningStrategy) {
            partitionSpec = this.partitioningStrategy.getPartitionSpec(recordWrapper.getRecord());
        }
        return partitionSpec;
    }
}

