/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.exception.DeserializerException;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class ProtoJsonProvider
implements JsonProvider {
    private static final Long LONG_MASK = 0xFFFFFFFFL;
    private final JsonFormat.Printer printer;
    private static final JsonOrgJsonProvider JSON_P = new JsonOrgJsonProvider();

    public ProtoJsonProvider(SinkConfig sinkConfig) {
        JsonFormat.Printer tempPrinter = JsonFormat.printer().preservingProtoFieldNames().omittingInsignificantWhitespace();
        if (sinkConfig.getSinkDefaultFieldValueEnable()) {
            tempPrinter = tempPrinter.includingDefaultValueFields();
        }
        this.printer = tempPrinter;
    }

    private String printMessage(DynamicMessage msg) {
        try {
            return this.printer.print((MessageOrBuilder)msg);
        }
        catch (InvalidProtocolBufferException e) {
            String name = msg.getDescriptorForType().getFullName();
            throw new DeserializerException("Unable to convert message to JSON" + name, (Exception)((Object)e));
        }
    }

    private boolean isPrimitive(Descriptors.FieldDescriptor fd) {
        return !fd.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE);
    }

    private Object getPrimitiveValue(Descriptors.FieldDescriptor fd, Object value) {
        switch (fd.getType()) {
            case UINT32: 
            case FIXED32: {
                return this.unsignedToString((Integer)value);
            }
            case UINT64: 
            case FIXED64: {
                return this.unsignedToString((Long)value);
            }
            case BYTES: {
                return BaseEncoding.base64().encode(((ByteString)value).toByteArray());
            }
            case ENUM: {
                if (fd.getEnumType().getFullName().equals("google.protobuf.NullValue")) {
                    return null;
                }
                return value.toString();
            }
        }
        return value;
    }

    private String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & LONG_MASK);
    }

    private String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public Object parse(String json) throws InvalidJsonException {
        return JSON_P.parse(json);
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        return JSON_P.parse(jsonStream, charset);
    }

    public String toJson(Object obj) {
        if (obj instanceof ProtoFieldValue) {
            return obj.toString();
        }
        if (obj instanceof DynamicMessage) {
            return this.printMessage((DynamicMessage)obj);
        }
        return JSON_P.toJson(obj);
    }

    public Object createArray() {
        return JSON_P.createArray();
    }

    public Object createMap() {
        return JSON_P.createMap();
    }

    public boolean isArray(Object obj) {
        if (obj instanceof ProtoFieldValue) {
            return ((ProtoFieldValue)obj).isArray();
        }
        return JSON_P.isArray(obj);
    }

    public int length(Object obj) {
        if (obj instanceof DynamicMessage) {
            return ((DynamicMessage)obj).getDescriptorForType().getFields().size();
        }
        if (obj instanceof ProtoFieldValue) {
            return ((List)((ProtoFieldValue)obj).value).size();
        }
        if (obj instanceof List) {
            return ((List)obj).size();
        }
        return JSON_P.length(obj);
    }

    public Iterable<?> toIterable(Object obj) {
        return (Iterable)obj;
    }

    public Collection<String> getPropertyKeys(Object obj) {
        Object val = obj;
        if (obj instanceof ProtoFieldValue) {
            return this.getPropertyKeys(((ProtoFieldValue)obj).value);
        }
        if (val instanceof DynamicMessage) {
            DynamicMessage msg = (DynamicMessage)val;
            return msg.getAllFields().entrySet().stream().map(fde -> ((Descriptors.FieldDescriptor)fde.getKey()).getName()).collect(Collectors.toList());
        }
        return JSON_P.getPropertyKeys(obj);
    }

    public Object getArrayIndex(Object obj, int idx) {
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj instanceof ProtoFieldValue) {
            return ((ProtoFieldValue)obj).getListValue(idx);
        }
        return JSON_P.getArrayIndex(obj, idx);
    }

    public Object getArrayIndex(Object obj, int idx, boolean unwrap) {
        return this.getArrayIndex(obj, idx);
    }

    public void setArrayIndex(Object array, int idx, Object newValue) {
        if (array instanceof JSONArray) {
            if (newValue instanceof ProtoFieldValue) {
                JSON_P.setArrayIndex(array, idx, ((ProtoFieldValue)newValue).getJsonValue());
            } else {
                JSON_P.setArrayIndex(array, idx, newValue);
            }
        } else {
            ((List)array).add(idx, newValue);
        }
    }

    public void setProperty(Object obj, Object key, Object value) {
        if (value instanceof ProtoFieldValue) {
            JSON_P.setProperty(obj, key, ((ProtoFieldValue)value).getJsonValue());
        } else {
            JSON_P.setProperty(obj, key, value);
        }
    }

    public void removeProperty(Object obj, Object key) {
        JSON_P.removeProperty(obj, key);
    }

    public boolean isMap(Object obj) {
        if (obj instanceof ProtoFieldValue) {
            return ((ProtoFieldValue)obj).isMap();
        }
        return obj instanceof DynamicMessage || JSON_P.isMap(obj);
    }

    public Object unwrap(Object obj) {
        if (obj instanceof ProtoFieldValue) {
            return ((ProtoFieldValue)obj).value;
        }
        return obj;
    }

    public Object getMapValue(Object obj, String key) {
        if (obj instanceof DynamicMessage) {
            DynamicMessage msg = (DynamicMessage)obj;
            Descriptors.FieldDescriptor fd = msg.getDescriptorForType().findFieldByName(key);
            if (fd == null) {
                throw new PathNotFoundException(String.format("\"%s\" not found", key));
            }
            Object value = msg.getField(fd);
            return new ProtoFieldValue(fd, value);
        }
        if (obj instanceof ProtoFieldValue) {
            return this.getMapValue(this.unwrap(obj), key);
        }
        return JSON_P.getMapValue(obj, key);
    }

    private class ProtoFieldValue
    implements Iterable {
        private Descriptors.FieldDescriptor fd;
        private Object value;

        private boolean isMap() {
            return this.fd.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE) && !this.isArray();
        }

        private boolean isArray() {
            return this.value instanceof List;
        }

        private Object getJsonValue() {
            String jsonValue;
            Descriptors.Descriptor parent = this.fd.getContainingType();
            if (this.isArray() && ((List)this.value).isEmpty()) {
                return this.value;
            }
            if (ProtoJsonProvider.this.isPrimitive(this.fd)) {
                if (this.isArray()) {
                    return new JSONArray((Object)((List)this.value).stream().map(a -> ProtoJsonProvider.this.getPrimitiveValue(this.fd, a)).toArray());
                }
                return ProtoJsonProvider.this.getPrimitiveValue(this.fd, this.value);
            }
            Object newValue = this.value;
            if (this.fd.isRepeated() && !this.isArray()) {
                newValue = new ArrayList(){
                    {
                        this.add(ProtoFieldValue.this.value);
                    }
                };
            }
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)parent).setField(this.fd, newValue);
            if (!this.fd.isRepeated() && !builder.hasField(this.fd)) {
                return this.value;
            }
            try {
                jsonValue = ProtoJsonProvider.this.printer.print((MessageOrBuilder)builder);
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializerException("Unable to get JSON value at " + this.fd.getFullName(), (Exception)((Object)e));
            }
            JSONObject js = new JSONObject(new JSONTokener(jsonValue));
            if (this.fd.isRepeated() && !(this.value instanceof List)) {
                return js.getJSONArray(this.fd.getName()).get(0);
            }
            return js.get(this.fd.getName());
        }

        private Object getListValue(int idx) {
            return new ProtoFieldValue(this.fd, ((List)this.value).get(idx));
        }

        public String toString() {
            return JSONWriter.valueToString((Object)this.getJsonValue());
        }

        public Iterator iterator() {
            return ((List)this.value).stream().map(o -> new ProtoFieldValue(this.fd, o)).iterator();
        }

        public ProtoFieldValue(Descriptors.FieldDescriptor fd, Object value) {
            this.fd = fd;
            this.value = value;
        }
    }
}

