/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gotocompany.depot.message.proto.ProtoField;
import java.io.IOException;
import java.util.List;

public class ProtoMapper {
    public static String generateColumnMappings(List<ProtoField> fields) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = ProtoMapper.generateColumnMappingsJson(fields);
        return objectMapper.writeValueAsString((Object)objectNode);
    }

    private static ObjectNode generateColumnMappingsJson(List<ProtoField> fields) {
        if (fields.size() == 0) {
            return JsonNodeFactory.instance.objectNode();
        }
        ObjectNode objNode = JsonNodeFactory.instance.objectNode();
        for (ProtoField field : fields) {
            if (field.isNested()) {
                ObjectNode innerJSONValue = ProtoMapper.generateColumnMappingsJson(field.getFields());
                innerJSONValue.put("record_name", field.getName());
                objNode.set(String.valueOf(field.getIndex()), (JsonNode)innerJSONValue);
                continue;
            }
            objNode.put(String.valueOf(field.getIndex()), field.getName());
        }
        return objNode;
    }
}

