/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.message.proto.converter.fields;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.gotocompany.depot.message.proto.converter.fields.ProtoField;
import java.util.Base64;
import java.util.Collection;
import java.util.stream.Collectors;

public class ByteProtoField
implements ProtoField {
    private final Descriptors.FieldDescriptor descriptor;
    private final Object fieldValue;

    @Override
    public Object getValue() {
        if (this.fieldValue instanceof Collection) {
            return ((Collection)this.fieldValue).stream().map(this::getByteString).collect(Collectors.toList());
        }
        return this.getByteString(this.fieldValue);
    }

    private Object getByteString(Object field) {
        ByteString byteString = (ByteString)field;
        byte[] bytes = byteString.toStringUtf8().getBytes();
        return this.base64Encode(bytes);
    }

    private String base64Encode(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes));
    }

    @Override
    public boolean matches() {
        return this.descriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES;
    }

    public ByteProtoField(Descriptors.FieldDescriptor descriptor, Object fieldValue) {
        this.descriptor = descriptor;
        this.fieldValue = fieldValue;
    }
}

