/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.metrics;

import com.timgroup.statsd.StatsDClient;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDReporter
implements Closeable {
    private final StatsDClient client;
    private final String globalTags;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsDReporter.class);

    public StatsDReporter(StatsDClient client, String ... globalTags) {
        this.client = client;
        this.globalTags = String.join((CharSequence)",", globalTags).replaceAll(":", "=");
    }

    public StatsDClient getClient() {
        return this.client;
    }

    public void captureCount(String metric, Long delta, String ... tags) {
        this.client.count(this.withTags(metric, tags), delta.longValue(), new String[0]);
    }

    public void captureHistogram(String metric, long delta, String ... tags) {
        this.client.time(this.withTags(metric, tags), delta, new String[0]);
    }

    public void captureDurationSince(String metric, Instant startTime, String ... tags) {
        this.client.recordExecutionTime(this.withTags(metric, tags), Duration.between(startTime, Instant.now()).toMillis(), new String[0]);
    }

    public void captureDuration(String metric, long duration, String ... tags) {
        this.client.recordExecutionTime(this.withTags(metric, tags), duration, new String[0]);
    }

    public void gauge(String metric, Integer value, String ... tags) {
        this.client.gauge(this.withTags(metric, tags), (long)value.intValue(), new String[0]);
    }

    public void increment(String metric, String ... tags) {
        this.captureCount(metric, 1L, tags);
    }

    public void recordEvent(String metric, String eventName, String ... tags) {
        this.client.recordSetValue(this.withTags(metric, tags), eventName, new String[0]);
    }

    private String withGlobalTags(String metric) {
        return metric + "," + this.globalTags;
    }

    private String withTags(String metric, String ... tags) {
        return Stream.concat(Stream.of(this.withGlobalTags(metric)), Stream.of(tags)).collect(Collectors.joining(","));
    }

    @Override
    public void close() throws IOException {
        LOGGER.info("StatsD connection closed");
        this.client.stop();
    }
}

