/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.client.entry;

import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.response.RedisClusterResponse;
import com.gotocompany.depot.redis.client.response.RedisStandaloneResponse;
import com.gotocompany.depot.redis.ttl.RedisTtl;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisException;

public class RedisHashSetFieldEntry
implements RedisEntry {
    private final String key;
    private final String field;
    private final String value;
    private final Instrumentation instrumentation;

    public String getKey() {
        return this.key;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public RedisStandaloneResponse send(Pipeline jedisPipelined, RedisTtl redisTTL) {
        this.instrumentation.logDebug("key: {}, field: {}, value: {}", this.key, this.field, this.value);
        Response response = jedisPipelined.hset(this.key, this.field, this.value);
        Response<Long> ttlResponse = redisTTL.setTtl(jedisPipelined, this.key);
        return new RedisStandaloneResponse("HSET", response, ttlResponse);
    }

    @Override
    public RedisClusterResponse send(JedisCluster jedisCluster, RedisTtl redisTTL) {
        this.instrumentation.logDebug("key: {}, field: {}, value: {}", this.key, this.field, this.value);
        try {
            Long response = jedisCluster.hset(this.key, this.field, this.value);
            Long ttlResponse = redisTTL.setTtl(jedisCluster, this.key);
            return new RedisClusterResponse("HSET", response, ttlResponse);
        }
        catch (JedisException e) {
            return new RedisClusterResponse(e.getMessage());
        }
    }

    public String toString() {
        return String.format("RedisHashSetFieldEntry Key %s, Field %s, Value %s", this.key, this.field, this.value);
    }

    public RedisHashSetFieldEntry(String key, String field, String value, Instrumentation instrumentation) {
        this.key = key;
        this.field = field;
        this.value = value;
        this.instrumentation = instrumentation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisHashSetFieldEntry)) {
            return false;
        }
        RedisHashSetFieldEntry other = (RedisHashSetFieldEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisHashSetFieldEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

