/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.parsers;

import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.entry.RedisKeyValueEntry;
import com.gotocompany.depot.redis.parsers.RedisEntryParser;
import java.util.Collections;
import java.util.List;

public class RedisKeyValueEntryParser
implements RedisEntryParser {
    private final StatsDReporter statsDReporter;
    private final Template keyTemplate;
    private final String fieldName;

    @Override
    public List<RedisEntry> getRedisEntry(ParsedMessage parsedMessage) {
        String redisKey = this.keyTemplate.parse(parsedMessage);
        String redisValue = parsedMessage.getFieldByName(this.fieldName).toString();
        RedisKeyValueEntry redisKeyValueEntry = new RedisKeyValueEntry(redisKey, redisValue, new Instrumentation(this.statsDReporter, RedisKeyValueEntry.class));
        return Collections.singletonList(redisKeyValueEntry);
    }

    public RedisKeyValueEntryParser(StatsDReporter statsDReporter, Template keyTemplate, String fieldName) {
        this.statsDReporter = statsDReporter;
        this.keyTemplate = keyTemplate;
        this.fieldName = fieldName;
    }
}

