/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.parsers;

import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.redis.client.entry.RedisEntry;
import com.gotocompany.depot.redis.client.entry.RedisListEntry;
import com.gotocompany.depot.redis.parsers.RedisEntryParser;
import java.util.Collections;
import java.util.List;

public class RedisListEntryParser
implements RedisEntryParser {
    private final StatsDReporter statsDReporter;
    private final Template keyTemplate;
    private final String field;

    @Override
    public List<RedisEntry> getRedisEntry(ParsedMessage parsedMessage) {
        String redisKey = this.keyTemplate.parse(parsedMessage);
        String redisValue = parsedMessage.getFieldByName(this.field).toString();
        return Collections.singletonList(new RedisListEntry(redisKey, redisValue, new Instrumentation(this.statsDReporter, RedisListEntry.class)));
    }

    public RedisListEntryParser(StatsDReporter statsDReporter, Template keyTemplate, String field) {
        this.statsDReporter = statsDReporter;
        this.keyTemplate = keyTemplate;
        this.field = field;
    }
}

