/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.redis.util;

import com.gotocompany.depot.config.RedisSinkConfig;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.redis.client.response.RedisResponse;
import com.gotocompany.depot.redis.record.RedisRecord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import redis.clients.jedis.DefaultJedisClientConfig;

public class RedisSinkUtils {
    public static Map<Long, ErrorInfo> getErrorsFromResponse(List<RedisRecord> redisRecords, List<RedisResponse> responses, Instrumentation instrumentation) {
        HashMap<Long, ErrorInfo> errors = new HashMap<Long, ErrorInfo>();
        IntStream.range(0, responses.size()).forEach(index -> {
            RedisResponse response = (RedisResponse)responses.get(index);
            if (response.isFailed()) {
                RedisRecord record = (RedisRecord)redisRecords.get(index);
                instrumentation.logError("Error while inserting to redis for message. Record: {}, Error: {}", record.toString(), response.getMessage());
                errors.put(record.getIndex(), new ErrorInfo(new Exception(response.getMessage()), ErrorType.DEFAULT_ERROR));
            }
        });
        return errors;
    }

    public static Map<Long, ErrorInfo> getNonRetryableErrors(List<RedisRecord> redisRecords, RuntimeException e, Instrumentation instrumentation) {
        HashMap<Long, ErrorInfo> errors = new HashMap<Long, ErrorInfo>();
        for (RedisRecord record : redisRecords) {
            instrumentation.logError("Error while inserting to redis for message. Record: {}, Error: {}", record.toString(), e.getMessage());
            errors.put(record.getIndex(), new ErrorInfo(new Exception(e.getMessage()), ErrorType.SINK_NON_RETRYABLE_ERROR));
        }
        return errors;
    }

    public static DefaultJedisClientConfig getJedisConfig(RedisSinkConfig config) {
        return DefaultJedisClientConfig.builder().connectionTimeoutMillis(config.getSinkRedisConnectionTimeoutMs()).socketTimeoutMillis(config.getSinkRedisSocketTimeoutMs()).user(config.getSinkRedisAuthUsername()).password(config.getSinkRedisAuthPassword()).build();
    }
}

