/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.utils;

import com.gotocompany.depot.exception.NonRetryableException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    public static void executeWithRetry(RunnableWithException runnableWithException, int maxRetries, long backoffMillis, Predicate<Exception> retryPredicate) {
        int retryCount = 0;
        Exception lastException = null;
        while (retryCount < maxRetries) {
            try {
                runnableWithException.run();
                break;
            }
            catch (Exception e) {
                if (!retryPredicate.test(e)) {
                    log.error("Non-retryable exception occurred, aborting operation", (Throwable)e);
                    throw new NonRetryableException(e.getMessage(), e);
                }
                lastException = e;
                log.info("Retrying operation, retry count: {}", (Object)(++retryCount));
                try {
                    Thread.sleep(backoffMillis);
                }
                catch (InterruptedException e2) {
                    log.error("Thread interrupted while sleeping", (Throwable)e2);
                }
            }
        }
        if (retryCount == maxRetries) {
            log.error("Max retries reached, aborting operation");
            throw new NonRetryableException("Max retries reached, aborting operation", lastException);
        }
    }

    @FunctionalInterface
    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

