/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery;

import com.gotocompany.depot.Sink;
import com.gotocompany.depot.bigquery.BigQuerySink;
import com.gotocompany.depot.bigquery.BigQueryStorageAPISink;
import com.gotocompany.depot.bigquery.BigqueryStencilUpdateListenerFactory;
import com.gotocompany.depot.bigquery.client.BigQueryClient;
import com.gotocompany.depot.bigquery.client.BigQueryRow;
import com.gotocompany.depot.bigquery.client.BigQueryRowWithInsertId;
import com.gotocompany.depot.bigquery.client.BigQueryRowWithoutInsertId;
import com.gotocompany.depot.bigquery.converter.MessageRecordConverterCache;
import com.gotocompany.depot.bigquery.handler.ErrorHandler;
import com.gotocompany.depot.bigquery.handler.ErrorHandlerFactory;
import com.gotocompany.depot.bigquery.storage.BigQueryStorageClient;
import com.gotocompany.depot.bigquery.storage.BigQueryStorageClientFactory;
import com.gotocompany.depot.bigquery.storage.BigQueryStorageResponseParser;
import com.gotocompany.depot.bigquery.storage.BigQueryWriter;
import com.gotocompany.depot.bigquery.storage.BigQueryWriterFactory;
import com.gotocompany.depot.bigquery.storage.BigQueryWriterUtils;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.metrics.BigQueryMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.stencil.DepotStencilUpdateListener;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.aeonbits.owner.ConfigFactory;

public class BigQuerySinkFactory {
    private final StatsDReporter statsDReporter;
    private final Function<Map<String, Object>, String> rowIDCreator;
    private final BigQuerySinkConfig sinkConfig;
    private BigQueryClient bigQueryClient;
    private BigQueryRow rowCreator;
    private BigQueryMetrics bigQueryMetrics;
    private ErrorHandler errorHandler;
    private MessageRecordConverterCache converterCache;
    private BigQueryStorageClient bigQueryStorageClient;
    private BigQueryStorageResponseParser responseParser;

    public BigQuerySinkFactory(Map<String, String> env, StatsDReporter statsDReporter, Function<Map<String, Object>, String> rowIDCreator) {
        this((BigQuerySinkConfig)ConfigFactory.create(BigQuerySinkConfig.class, (Map[])new Map[]{env}), statsDReporter, rowIDCreator);
    }

    public BigQuerySinkFactory(BigQuerySinkConfig sinkConfig, StatsDReporter statsDReporter, Function<Map<String, Object>, String> rowIDCreator) {
        this.sinkConfig = sinkConfig;
        this.rowIDCreator = rowIDCreator;
        this.statsDReporter = statsDReporter;
    }

    public BigQuerySinkFactory(BigQuerySinkConfig sinkConfig) {
        this(sinkConfig, new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]), null);
    }

    public BigQuerySinkFactory(BigQuerySinkConfig sinkConfig, StatsDReporter statsDReporter) {
        this(sinkConfig, statsDReporter, null);
    }

    public BigQuerySinkFactory(BigQuerySinkConfig sinkConfig, Function<Map<String, Object>, String> rowIDCreator) {
        this(sinkConfig, new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]), rowIDCreator);
    }

    public void init() {
        try {
            this.bigQueryMetrics = new BigQueryMetrics(this.sinkConfig);
            this.bigQueryClient = new BigQueryClient(this.sinkConfig, this.bigQueryMetrics, new Instrumentation(this.statsDReporter, BigQueryClient.class));
            this.converterCache = new MessageRecordConverterCache();
            this.errorHandler = ErrorHandlerFactory.create(this.sinkConfig, this.bigQueryClient, this.statsDReporter);
            DepotStencilUpdateListener depotStencilUpdateListener = BigqueryStencilUpdateListenerFactory.create(this.sinkConfig, this.bigQueryClient, this.converterCache, this.statsDReporter);
            MessageParser messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter, depotStencilUpdateListener);
            depotStencilUpdateListener.setMessageParser(messageParser);
            depotStencilUpdateListener.updateSchema();
            this.rowCreator = this.sinkConfig.isRowInsertIdEnabled() != false ? new BigQueryRowWithInsertId(this.rowIDCreator) : new BigQueryRowWithoutInsertId();
            if (this.sinkConfig.getSinkBigqueryStorageAPIEnable()) {
                BigQueryWriter bigQueryWriter = BigQueryWriterFactory.createBigQueryWriter(this.sinkConfig, BigQueryWriterUtils::getBigQueryWriterClient, BigQueryWriterUtils::getCredentialsProvider, BigQueryWriterUtils::getStreamWriter, new Instrumentation(this.statsDReporter, BigQueryWriter.class), this.bigQueryMetrics);
                bigQueryWriter.init();
                this.bigQueryStorageClient = BigQueryStorageClientFactory.createBigQueryStorageClient(this.sinkConfig, messageParser, bigQueryWriter);
                this.responseParser = new BigQueryStorageResponseParser(this.sinkConfig, new Instrumentation(this.statsDReporter, BigQueryStorageResponseParser.class), this.bigQueryMetrics);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception occurred while creating sink", e);
        }
    }

    public Sink create() {
        if (this.sinkConfig.getSinkBigqueryStorageAPIEnable()) {
            return new BigQueryStorageAPISink(this.bigQueryStorageClient, this.responseParser);
        }
        return new BigQuerySink(this.bigQueryClient, this.converterCache, this.rowCreator, this.bigQueryMetrics, new Instrumentation(this.statsDReporter, BigQuerySink.class), this.errorHandler);
    }
}

