/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.client;

import com.google.cloud.bigquery.InsertAllResponse;
import com.gotocompany.depot.bigquery.error.ErrorDescriptor;
import com.gotocompany.depot.bigquery.error.ErrorParser;
import com.gotocompany.depot.bigquery.error.InvalidSchemaError;
import com.gotocompany.depot.bigquery.error.OOBError;
import com.gotocompany.depot.bigquery.error.StoppedError;
import com.gotocompany.depot.bigquery.error.UnknownError;
import com.gotocompany.depot.bigquery.exception.BigQuerySinkException;
import com.gotocompany.depot.bigquery.models.Record;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.metrics.BigQueryMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigQueryResponseParser {
    public static Map<Long, ErrorInfo> getErrorsFromBQResponse(List<Record> records, InsertAllResponse bqResponse, BigQueryMetrics bigQueryMetrics, Instrumentation instrumentation) {
        HashMap<Long, ErrorInfo> errorInfoResponse = new HashMap<Long, ErrorInfo>();
        if (!bqResponse.hasErrors()) {
            return errorInfoResponse;
        }
        Map insertErrorsMap = bqResponse.getInsertErrors();
        for (Map.Entry errorEntry : insertErrorsMap.entrySet()) {
            Record record = records.get(((Long)errorEntry.getKey()).intValue());
            long messageIndex = record.getIndex();
            List<ErrorDescriptor> errors = ErrorParser.parseError((List)errorEntry.getValue());
            instrumentation.logError("Error while bigquery insert for message. \nRecord: {}, \nError: {}, \nMetaData: {}", record.getColumns(), errors, record.getMetadata());
            if (BigQueryResponseParser.errorMatch(errors, UnknownError.class)) {
                errorInfoResponse.put(messageIndex, new ErrorInfo(new BigQuerySinkException(), ErrorType.SINK_UNKNOWN_ERROR));
                instrumentation.incrementCounter(bigQueryMetrics.getBigqueryTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigQueryMetrics.BigQueryErrorType.UNKNOWN_ERROR}));
                continue;
            }
            if (BigQueryResponseParser.errorMatch(errors, InvalidSchemaError.class)) {
                errorInfoResponse.put(messageIndex, new ErrorInfo(new BigQuerySinkException(), ErrorType.SINK_4XX_ERROR));
                instrumentation.incrementCounter(bigQueryMetrics.getBigqueryTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigQueryMetrics.BigQueryErrorType.INVALID_SCHEMA_ERROR}));
                continue;
            }
            if (BigQueryResponseParser.errorMatch(errors, OOBError.class)) {
                errorInfoResponse.put(messageIndex, new ErrorInfo(new BigQuerySinkException(), ErrorType.SINK_4XX_ERROR));
                instrumentation.incrementCounter(bigQueryMetrics.getBigqueryTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigQueryMetrics.BigQueryErrorType.OOB_ERROR}));
                continue;
            }
            if (!BigQueryResponseParser.errorMatch(errors, StoppedError.class)) continue;
            errorInfoResponse.put(messageIndex, new ErrorInfo(new BigQuerySinkException(), ErrorType.SINK_5XX_ERROR));
            instrumentation.incrementCounter(bigQueryMetrics.getBigqueryTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigQueryMetrics.BigQueryErrorType.STOPPED_ERROR}));
        }
        return errorInfoResponse;
    }

    private static boolean errorMatch(List<ErrorDescriptor> errors, Class c) {
        return errors.stream().anyMatch(errorDescriptor -> errorDescriptor.getClass().equals(c));
    }
}

