/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.client;

import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.gotocompany.depot.bigquery.exception.BQClusteringKeysException;
import com.gotocompany.depot.bigquery.exception.BQPartitionKeyNotSpecified;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BigQueryTableDefinition {
    private static final int MAX_CLUSTERING_KEYS = 4;
    private final BigQuerySinkConfig bqConfig;

    public StandardTableDefinition getTableDefinition(Schema schema) {
        StandardTableDefinition.Builder tableDefinitionBuilder = StandardTableDefinition.newBuilder().setSchema(schema);
        if (this.bqConfig.isTablePartitioningEnabled().booleanValue()) {
            TimePartitioning partitioning = this.getPartitionedTableDefinition(schema);
            tableDefinitionBuilder.setTimePartitioning(partitioning);
        }
        if (this.bqConfig.isTableClusteringEnabled().booleanValue()) {
            Clustering clustering = this.getClusteredTableDefinition(schema);
            tableDefinitionBuilder.setClustering(clustering);
        }
        return tableDefinitionBuilder.build();
    }

    private TimePartitioning getPartitionedTableDefinition(Schema schema) {
        String tablePartitionKey = this.bqConfig.getTablePartitionKey();
        if (tablePartitionKey == null) {
            throw new BQPartitionKeyNotSpecified(String.format("Partition key not specified for the table: %s", this.bqConfig.getTableName()));
        }
        Optional<Field> partitionFieldOptional = schema.getFields().stream().filter(obj -> tablePartitionKey.equals(obj.getName())).findFirst();
        if (!partitionFieldOptional.isPresent()) {
            throw new BQPartitionKeyNotSpecified(String.format("Partition key %s is not present in the schema", tablePartitionKey));
        }
        Field partitionField = partitionFieldOptional.get();
        if (partitionField.getType() == LegacySQLTypeName.TIMESTAMP || partitionField.getType() == LegacySQLTypeName.DATE) {
            Long partitionExpiry = this.bqConfig.getBigQueryTablePartitionExpiryMS();
            return TimePartitioning.newBuilder((TimePartitioning.Type)TimePartitioning.Type.DAY).setField(tablePartitionKey).setRequirePartitionFilter(Boolean.valueOf(true)).setExpirationMs(partitionExpiry <= 0L ? null : partitionExpiry).build();
        }
        throw new UnsupportedOperationException("Range BigQuery partitioning is not supported, supported partition fields have to be of DATE or TIMESTAMP type");
    }

    private Clustering getClusteredTableDefinition(Schema schema) {
        if (this.bqConfig.getTableClusteringKeys().isEmpty()) {
            throw new BQClusteringKeysException(String.format("Clustering key not specified for the table: %s", this.bqConfig.getTableName()));
        }
        List<String> columnNames = this.bqConfig.getTableClusteringKeys();
        if (columnNames.size() > 4) {
            throw new BQClusteringKeysException(String.format("Max number of columns for clustering is %d", 4));
        }
        List fieldNames = schema.getFields().stream().map(Field::getName).collect(Collectors.toList());
        if (!fieldNames.containsAll(columnNames)) {
            throw new BQClusteringKeysException(String.format("One or more column names specified %s not exist on the schema or a nested type which is not supported for clustering", columnNames));
        }
        return Clustering.newBuilder().setFields(columnNames).build();
    }

    public BigQueryTableDefinition(BigQuerySinkConfig bqConfig) {
        this.bqConfig = bqConfig;
    }
}

