/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigquery.handler;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.gotocompany.depot.bigquery.client.BigQueryClient;
import com.gotocompany.depot.bigquery.handler.ErrorHandler;
import com.gotocompany.depot.bigquery.models.Record;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.BigQuerySinkConfig;
import com.gotocompany.depot.metrics.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonErrorHandler
implements ErrorHandler {
    private final BigQueryClient bigQueryClient;
    private final boolean castAllColumnsToStringDataType;
    private final Map<String, String> metadataColumnsTypesMap;
    private final String bqMetadataNamespace;
    private final Instrumentation instrumentation;
    private final Map<String, String> defaultColumnsMap;

    public JsonErrorHandler(BigQueryClient bigQueryClient, BigQuerySinkConfig bigQuerySinkConfig, Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.bigQueryClient = bigQueryClient;
        this.defaultColumnsMap = bigQuerySinkConfig.getSinkBigqueryDefaultColumns().stream().collect(Collectors.toMap(TupleString::getFirst, TupleString::getSecond));
        this.castAllColumnsToStringDataType = bigQuerySinkConfig.getSinkBigqueryDefaultDatatypeStringEnable();
        this.bqMetadataNamespace = bigQuerySinkConfig.getBqMetadataNamespace();
        this.metadataColumnsTypesMap = !bigQuerySinkConfig.shouldAddMetadata() ? Collections.emptyMap() : bigQuerySinkConfig.getMetadataColumnsTypes().stream().collect(Collectors.toMap(TupleString::getFirst, TupleString::getSecond));
    }

    @Override
    public void handle(Map<Long, List<BigQueryError>> insertErrors, List<Record> records) {
        Schema schema = this.bigQueryClient.getSchema();
        FieldList existingFieldList = schema.getFields();
        List<Map.Entry<Long, List<BigQueryError>>> unknownFieldBqErrors = this.getUnknownFieldBqErrors(insertErrors);
        if (!unknownFieldBqErrors.isEmpty()) {
            ArrayList bqSchemaFields = unknownFieldBqErrors.stream().map(x -> this.getColumnNamesForRecordsWhichHadUnknownBqFieldErrors(records, (Map.Entry<Long, List<BigQueryError>>)x)).flatMap(Collection::stream).filter(key -> this.filterExistingFields(existingFieldList, (String)key)).map(this::getField).distinct().collect(Collectors.toCollection(ArrayList::new));
            this.instrumentation.logInfo("updating table with missing fields detected {}", bqSchemaFields);
            existingFieldList.iterator().forEachRemaining(bqSchemaFields::add);
            this.bigQueryClient.upsertTable(bqSchemaFields);
        }
    }

    private Set<String> getColumnNamesForRecordsWhichHadUnknownBqFieldErrors(List<Record> records, Map.Entry<Long, List<BigQueryError>> x) {
        int recordKey = x.getKey().intValue();
        return records.get(recordKey).getColumns().keySet();
    }

    private List<Map.Entry<Long, List<BigQueryError>>> getUnknownFieldBqErrors(Map<Long, List<BigQueryError>> insertErrors) {
        return insertErrors.entrySet().stream().filter(x -> {
            List value = (List)x.getValue();
            List<BigQueryError> bqErrorsWithNoSuchFields = this.getBqErrorsWithNoSuchFields(value);
            return !bqErrorsWithNoSuchFields.isEmpty();
        }).collect(Collectors.toList());
    }

    private List<BigQueryError> getBqErrorsWithNoSuchFields(List<BigQueryError> value) {
        return value.stream().filter(bigQueryError -> bigQueryError.getReason().equals("invalid") && bigQueryError.getMessage().contains("no such field")).collect(Collectors.toList());
    }

    private Field getField(String key) {
        if (!this.bqMetadataNamespace.isEmpty()) {
            throw new UnsupportedOperationException("metadata namespace is not supported, because nested json structure is not supported");
        }
        if (this.metadataColumnsTypesMap.containsKey(key)) {
            return Field.newBuilder((String)key, (LegacySQLTypeName)LegacySQLTypeName.valueOfStrict((String)this.metadataColumnsTypesMap.get(key).toUpperCase()), (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
        }
        if (this.defaultColumnsMap.containsKey(key)) {
            return Field.newBuilder((String)key, (LegacySQLTypeName)LegacySQLTypeName.valueOfStrict((String)this.defaultColumnsMap.get(key).toUpperCase()), (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
        }
        if (!this.castAllColumnsToStringDataType) {
            throw new UnsupportedOperationException("only string data type is supported for fields other than partition key");
        }
        return Field.newBuilder((String)key, (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build();
    }

    private boolean filterExistingFields(FieldList existingFieldList, String key) {
        try {
            existingFieldList.get(key);
            return false;
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
    }
}

