/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigtable;

import com.gotocompany.depot.Sink;
import com.gotocompany.depot.bigtable.BigTableSink;
import com.gotocompany.depot.bigtable.client.BigTableClient;
import com.gotocompany.depot.bigtable.model.BigTableSchema;
import com.gotocompany.depot.bigtable.parser.BigTableRecordParser;
import com.gotocompany.depot.bigtable.parser.BigTableRowKeyParser;
import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.common.Tuple;
import com.gotocompany.depot.config.BigTableSinkConfig;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.InvalidTemplateException;
import com.gotocompany.depot.message.MessageParser;
import com.gotocompany.depot.message.MessageParserFactory;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import com.gotocompany.depot.metrics.BigTableMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import com.gotocompany.depot.metrics.StatsDReporter;
import com.gotocompany.depot.utils.MessageConfigUtils;
import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;
import java.io.IOException;

public class BigTableSinkFactory {
    private final BigTableSinkConfig sinkConfig;
    private final StatsDReporter statsDReporter;
    private BigTableClient bigTableClient;
    private BigTableRecordParser bigTableRecordParser;
    private BigTableMetrics bigtableMetrics;

    public BigTableSinkFactory(BigTableSinkConfig sinkConfig, StatsDReporter statsDReporter) {
        this.sinkConfig = sinkConfig;
        this.statsDReporter = statsDReporter;
    }

    public BigTableSinkFactory(BigTableSinkConfig sinkConfig) {
        this(sinkConfig, new StatsDReporter((StatsDClient)new NoOpStatsDClient(), new String[0]));
    }

    public void init() {
        try {
            Instrumentation instrumentation = new Instrumentation(this.statsDReporter, BigTableSinkFactory.class);
            String bigtableConfig = String.format("\n\tbigtable.gcloud.project = %s\n\tbigtable.instance = %s\n\tbigtable.table = %s\n\tbigtable.credential.path = %s\n\tbigtable.row.key.template = %s\n\tbigtable.column.family.mapping = %s\n\t", this.sinkConfig.getGCloudProjectID(), this.sinkConfig.getInstanceId(), this.sinkConfig.getTableId(), this.sinkConfig.getCredentialPath(), this.sinkConfig.getRowKeyTemplate(), this.sinkConfig.getColumnFamilyMapping());
            instrumentation.logInfo(bigtableConfig, new Object[0]);
            BigTableSchema bigtableSchema = new BigTableSchema(this.sinkConfig.getColumnFamilyMapping());
            this.bigtableMetrics = new BigTableMetrics(this.sinkConfig);
            this.bigTableClient = new BigTableClient(this.sinkConfig, bigtableSchema, this.bigtableMetrics, new Instrumentation(this.statsDReporter, BigTableClient.class));
            this.bigTableClient.validateBigTableSchema();
            Tuple<SinkConnectorSchemaMessageMode, String> modeAndSchema = MessageConfigUtils.getModeAndSchema(this.sinkConfig);
            MessageParser messageParser = MessageParserFactory.getParser(this.sinkConfig, this.statsDReporter);
            Template keyTemplate = new Template(this.sinkConfig.getRowKeyTemplate());
            BigTableRowKeyParser bigTableRowKeyParser = new BigTableRowKeyParser(keyTemplate);
            this.bigTableRecordParser = new BigTableRecordParser(messageParser, bigTableRowKeyParser, modeAndSchema, bigtableSchema);
            instrumentation.logInfo("Connection to bigtable established successfully", new Object[0]);
        }
        catch (InvalidTemplateException | IOException e) {
            throw new ConfigurationException("Exception occurred while creating sink", e);
        }
    }

    public Sink create() {
        return new BigTableSink(this.bigTableClient, this.bigTableRecordParser, this.bigtableMetrics, new Instrumentation(this.statsDReporter, BigTableSink.class));
    }
}

