/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.bigtable.parser;

import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.gotocompany.depot.bigtable.model.BigTableRecord;
import com.gotocompany.depot.bigtable.response.BigTableResponse;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.metrics.BigTableMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BigTableResponseParser {
    public static Map<Long, ErrorInfo> getErrorsFromSinkResponse(List<BigTableRecord> validRecords, BigTableResponse bigTableResponse, BigTableMetrics bigtableMetrics, Instrumentation instrumentation) {
        HashMap<Long, ErrorInfo> errorInfoMap = new HashMap<Long, ErrorInfo>();
        for (MutateRowsException.FailedMutation fm : bigTableResponse.getFailedMutations()) {
            BigTableRecord record = validRecords.get(fm.getIndex());
            long messageIndex = record.getIndex();
            String httpStatusCode = String.valueOf(fm.getError().getStatusCode().getCode().getHttpStatusCode());
            if (fm.getError().isRetryable()) {
                errorInfoMap.put(messageIndex, new ErrorInfo((Exception)fm.getError(), ErrorType.SINK_RETRYABLE_ERROR));
            } else if (httpStatusCode.startsWith("4")) {
                errorInfoMap.put(messageIndex, new ErrorInfo((Exception)fm.getError(), ErrorType.SINK_4XX_ERROR));
            } else if (httpStatusCode.startsWith("5")) {
                errorInfoMap.put(messageIndex, new ErrorInfo((Exception)fm.getError(), ErrorType.SINK_5XX_ERROR));
            } else {
                errorInfoMap.put(messageIndex, new ErrorInfo((Exception)fm.getError(), ErrorType.SINK_UNKNOWN_ERROR));
            }
            instrumentation.logError("Error while inserting to Bigtable. Record Metadata: {}, Cause: {}, Reason: {}, StatusCode: {}, HttpCode: {}", record.getMetadata(), fm.getError().getCause(), fm.getError().getReason(), fm.getError().getStatusCode().getCode(), fm.getError().getStatusCode().getCode().getHttpStatusCode());
            if (fm.getError().getErrorDetails() == null) {
                instrumentation.incrementCounter(bigtableMetrics.getBigtableTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigTableMetrics.BigTableErrorType.RPC_FAILURE}));
                continue;
            }
            if (fm.getError().getErrorDetails().getBadRequest() != null) {
                instrumentation.incrementCounter(bigtableMetrics.getBigtableTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigTableMetrics.BigTableErrorType.BAD_REQUEST}));
                continue;
            }
            if (fm.getError().getErrorDetails().getQuotaFailure() != null) {
                instrumentation.incrementCounter(bigtableMetrics.getBigtableTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigTableMetrics.BigTableErrorType.QUOTA_FAILURE}));
                continue;
            }
            if (fm.getError().getErrorDetails().getPreconditionFailure() != null) {
                instrumentation.incrementCounter(bigtableMetrics.getBigtableTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigTableMetrics.BigTableErrorType.PRECONDITION_FAILURE}));
                continue;
            }
            instrumentation.incrementCounter(bigtableMetrics.getBigtableTotalErrorsMetrics(), String.format("error=%s", new Object[]{BigTableMetrics.BigTableErrorType.RPC_FAILURE}));
        }
        return errorInfoMap;
    }
}

