/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.common;

import com.google.common.base.Splitter;
import com.gotocompany.depot.exception.InvalidTemplateException;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class Template {
    private final String templatePattern;
    private final List<String> patternVariableFieldNames;

    public Template(String template) throws InvalidTemplateException {
        if (template == null || template.isEmpty()) {
            throw new InvalidTemplateException("Template cannot be empty");
        }
        ArrayList templateStrings = new ArrayList();
        Splitter.onPattern((String)"(?<!/,),(?!/)").omitEmptyStrings().split((CharSequence)template).forEach(s -> templateStrings.add(s.trim()));
        this.templatePattern = ((String)templateStrings.get(0)).replaceAll("/,/", ",");
        this.patternVariableFieldNames = templateStrings.subList(1, templateStrings.size());
        this.validate();
    }

    private void validate() throws InvalidTemplateException {
        int validArgs = StringUtils.countVariables(this.templatePattern);
        int values = this.patternVariableFieldNames.size();
        int variables = StringUtils.count(this.templatePattern, '%');
        if (validArgs != values || variables != values) {
            throw new InvalidTemplateException(String.format("Template is not valid, variables=%d, validArgs=%d, values=%d", variables, validArgs, values));
        }
    }

    public String parse(ParsedMessage parsedMessage) {
        Object[] patternVariableData = this.patternVariableFieldNames.stream().map(fieldName -> parsedMessage.getFieldByName((String)fieldName).toString()).toArray();
        return String.format(this.templatePattern, patternVariableData);
    }

    public Object parseWithType(ParsedMessage parsedMessage) {
        if (!this.patternVariableFieldNames.isEmpty()) {
            if (this.templatePattern.equals("%s")) {
                return parsedMessage.getFieldByName(this.patternVariableFieldNames.get(0));
            }
            return this.parse(parsedMessage);
        }
        return this.templatePattern;
    }

    public String getTemplateString() {
        return this.templatePattern;
    }

    public boolean isConstantString() {
        return this.patternVariableFieldNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$templatePattern = this.templatePattern;
        String other$templatePattern = other.templatePattern;
        if (this$templatePattern == null ? other$templatePattern != null : !this$templatePattern.equals(other$templatePattern)) {
            return false;
        }
        List<String> this$patternVariableFieldNames = this.patternVariableFieldNames;
        List<String> other$patternVariableFieldNames = other.patternVariableFieldNames;
        return !(this$patternVariableFieldNames == null ? other$patternVariableFieldNames != null : !((Object)this$patternVariableFieldNames).equals(other$patternVariableFieldNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $templatePattern = this.templatePattern;
        result = result * 59 + ($templatePattern == null ? 43 : $templatePattern.hashCode());
        List<String> $patternVariableFieldNames = this.patternVariableFieldNames;
        result = result * 59 + ($patternVariableFieldNames == null ? 43 : ((Object)$patternVariableFieldNames).hashCode());
        return result;
    }
}

