/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.common.client.auth;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gotocompany.depot.common.client.auth.OAuth2AccessToken;
import com.gotocompany.depot.common.exception.OAuth2Exception;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class OAuth2Client {
    private final HttpClient client;
    private final String clientId;
    private final String clientSecret;
    private final String scope;
    private final String accessTokenEndpoint;
    private final int timeoutMs = 5000;
    private static final String SUCCESS_CODE_PATTERN = "^2.*";

    public OAuth2Client(String clientId, String clientSecret, String scope, String accessTokenEndpoint) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.accessTokenEndpoint = accessTokenEndpoint;
        this.client = this.httpClient();
    }

    private CloseableHttpClient httpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public OAuth2AccessToken requestClientCredentialsGrantAccessToken() throws IOException {
        HttpPost req = new HttpPost(this.accessTokenEndpoint);
        req.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> kv = new ArrayList<BasicNameValuePair>();
        kv.add(new BasicNameValuePair("client_id", this.clientId));
        kv.add(new BasicNameValuePair("client_secret", this.clientSecret));
        kv.add(new BasicNameValuePair("scope", this.scope));
        kv.add(new BasicNameValuePair("grant_type", "client_credentials"));
        req.setEntity((HttpEntity)new UrlEncodedFormEntity(kv, "UTF-8"));
        HttpResponse response = this.client.execute((HttpUriRequest)req);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        Type responseMapType = new TypeToken<Map<String, String>>(){}.getType();
        Map map = (Map)new Gson().fromJson(body, responseMapType);
        if (!Pattern.compile(SUCCESS_CODE_PATTERN).matcher(String.valueOf(response.getStatusLine().getStatusCode())).matches()) {
            throw new OAuth2Exception("OAuthException: " + (String)map.get("error"));
        }
        String accessToken = (String)map.get("access_token");
        String expiresInRaw = (String)map.get("expires_in");
        Integer expiresIn = expiresInRaw == null ? null : Integer.valueOf(expiresInRaw);
        return new OAuth2AccessToken(accessToken, expiresIn);
    }
}

