/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.common.client.auth;

import com.gotocompany.depot.common.client.auth.OAuth2AccessToken;
import com.gotocompany.depot.common.client.auth.OAuth2Client;
import com.gotocompany.depot.metrics.Instrumentation;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;

public class OAuth2Credential
implements Interceptor {
    private final OAuth2Client client;
    private final Instrumentation instrumentation;
    private OAuth2AccessToken accessToken;

    public OAuth2Credential(Instrumentation instrumentation, String clientId, String clientSecret, String scope, String accessTokenEndpoint) {
        this.instrumentation = instrumentation;
        this.client = new OAuth2Client(clientId, clientSecret, scope, accessTokenEndpoint);
    }

    public void requestAccessToken() throws IOException {
        this.instrumentation.logInfo("Requesting Access Token, expires in: {0}", this.accessToken == null ? "<none>" : this.accessToken.getExpiresIn());
        OAuth2AccessToken token = this.client.requestClientCredentialsGrantAccessToken();
        this.setAccessToken(token);
    }

    public HttpRequestInterceptor requestInterceptor() {
        return (request, context) -> {
            try {
                if (this.getAccessToken() == null || this.getAccessToken().isExpired()) {
                    this.requestAccessToken();
                }
                request.addHeader("Authorization", "Bearer " + this.getAccessToken().toString());
            }
            catch (IOException e) {
                this.instrumentation.logWarn("OAuth2 request access token failed: {0}", e.getMessage());
            }
        };
    }

    public HttpResponseInterceptor responseInterceptor() {
        return (response, context) -> {
            boolean isTokenExpired;
            boolean bl = isTokenExpired = response.getStatusLine().getStatusCode() == 401;
            if (isTokenExpired) {
                this.setAccessToken(null);
            }
        };
    }

    public HttpClientBuilder initialize(HttpClientBuilder builder) {
        return builder.addInterceptorFirst(this.requestInterceptor()).addInterceptorLast(this.responseInterceptor());
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        boolean isTokenExpired;
        Request request = chain.request();
        try {
            if (this.getAccessToken() == null || this.getAccessToken().isExpired()) {
                this.requestAccessToken();
            }
            request = request.newBuilder().header("Authorization", "Bearer " + this.getAccessToken().toString()).build();
        }
        catch (IOException e) {
            this.instrumentation.logWarn("OAuth2 request access token failed: {0}", e.getMessage());
        }
        Response response = chain.proceed(request);
        boolean bl = isTokenExpired = response.code() == 401;
        if (isTokenExpired) {
            this.setAccessToken(null);
        }
        return response;
    }
}

