/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config;

import com.aliyun.odps.tunnel.io.CompressOption;
import com.gotocompany.depot.common.TupleString;
import com.gotocompany.depot.config.converter.ConfToListConverter;
import com.gotocompany.depot.config.converter.KeyValuePairsToMapConverter;
import com.gotocompany.depot.config.converter.LocalDateTimeConverter;
import com.gotocompany.depot.config.converter.MaxComputeOdpsGlobalSettingsConverter;
import com.gotocompany.depot.config.converter.ZoneIdConverter;
import com.gotocompany.depot.maxcompute.enumeration.MaxComputeTimestampDataType;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Config;

public interface MaxComputeSinkConfig
extends Config {
    @Config.Key(value="SINK_MAXCOMPUTE_ODPS_URL")
    public String getMaxComputeOdpsUrl();

    @Config.Key(value="SINK_MAXCOMPUTE_TUNNEL_URL")
    public String getMaxComputeTunnelUrl();

    @Config.Key(value="SINK_MAXCOMPUTE_ACCESS_ID")
    public String getMaxComputeAccessId();

    @Config.Key(value="SINK_MAXCOMPUTE_ACCESS_KEY")
    public String getMaxComputeAccessKey();

    @Config.Key(value="SINK_MAXCOMPUTE_PROJECT_ID")
    public String getMaxComputeProjectId();

    @Config.Key(value="SINK_MAXCOMPUTE_METADATA_NAMESPACE")
    @Config.DefaultValue(value="")
    public String getMaxcomputeMetadataNamespace();

    @Config.Key(value="SINK_MAXCOMPUTE_ADD_METADATA_ENABLED")
    @Config.DefaultValue(value="true")
    public boolean shouldAddMetadata();

    @Config.DefaultValue(value="")
    @Config.Key(value="SINK_MAXCOMPUTE_METADATA_COLUMNS_TYPES")
    @Config.ConverterClass(value=ConfToListConverter.class)
    @Config.Separator(value=",")
    public List<TupleString> getMetadataColumnsTypes();

    @Config.Key(value="SINK_MAXCOMPUTE_SCHEMA")
    @Config.DefaultValue(value="default")
    public String getMaxComputeSchema();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_TIMESTAMP_TO_MAXCOMPUTE_TYPE")
    @Config.DefaultValue(value="TIMESTAMP")
    public MaxComputeTimestampDataType getMaxComputeProtoTimestampToMaxcomputeType();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_PARTITIONING_ENABLE")
    @Config.DefaultValue(value="false")
    public Boolean isTablePartitioningEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_PARTITION_KEY")
    public String getTablePartitionKey();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_PARTITION_COLUMN_NAME")
    public String getTablePartitionColumnName();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_PARTITION_BY_TIMESTAMP_TIME_UNIT")
    @Config.DefaultValue(value="DAY")
    public String getTablePartitionByTimestampTimeUnit();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_NAME")
    public String getMaxComputeTableName();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_LIFECYCLE_DAYS")
    public Long getMaxComputeTableLifecycleDays();

    @Config.Key(value="SINK_MAXCOMPUTE_RECORD_PACK_FLUSH_TIMEOUT_MS")
    @Config.DefaultValue(value="-1")
    public Long getMaxComputeRecordPackFlushTimeoutMs();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_COMPRESSION_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isStreamingInsertCompressEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_COMPRESSION_ALGORITHM")
    @Config.DefaultValue(value="ODPS_LZ4_FRAME")
    public CompressOption.CompressAlgorithm getMaxComputeCompressionAlgorithm();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_COMPRESSION_LEVEL")
    @Config.DefaultValue(value="1")
    public int getMaxComputeCompressionLevel();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_COMPRESSION_STRATEGY")
    @Config.DefaultValue(value="0")
    public int getMaxComputeCompressionStrategy();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_MAXIMUM_SESSION_COUNT")
    @Config.DefaultValue(value="2")
    public int getStreamingInsertMaximumSessionCount();

    @Config.Key(value="SINK_MAXCOMPUTE_STREAMING_INSERT_TUNNEL_SLOT_COUNT_PER_SESSION")
    @Config.DefaultValue(value="1")
    public long getStreamingInsertTunnelSlotCountPerSession();

    @Config.Key(value="SINK_MAXCOMPUTE_ZONE_ID")
    @Config.ConverterClass(value=ZoneIdConverter.class)
    @Config.DefaultValue(value="Asia/Bangkok")
    public ZoneId getZoneId();

    @Config.Key(value="SINK_MAXCOMPUTE_MAX_DDL_RETRY_COUNT")
    @Config.DefaultValue(value="10")
    public int getMaxDdlRetryCount();

    @Config.Key(value="SINK_MAXCOMPUTE_DDL_RETRY_BACKOFF_MILLIS")
    @Config.DefaultValue(value="1000")
    public long getDdlRetryBackoffMillis();

    @Config.Key(value="SINK_MAXCOMPUTE_ODPS_GLOBAL_SETTINGS")
    @Config.ConverterClass(value=MaxComputeOdpsGlobalSettingsConverter.class)
    @Config.DefaultValue(value="odps.schema.evolution.enable=true,odps.namespace.schema=true")
    public Map<String, String> getOdpsGlobalSettings();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_VALIDATOR_NAME_REGEX")
    @Config.DefaultValue(value="^[A-Za-z][A-Za-z0-9_]{0,127}$")
    public String getTableValidatorNameRegex();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_VALIDATOR_MAX_COLUMNS_PER_TABLE")
    @Config.DefaultValue(value="1200")
    public int getTableValidatorMaxColumnsPerTable();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_VALIDATOR_MAX_PARTITION_KEYS_PER_TABLE")
    @Config.DefaultValue(value="6")
    public int getTableValidatorMaxPartitionKeysPerTable();

    @Config.Key(value="SINK_MAXCOMPUTE_VALID_MIN_TIMESTAMP")
    @Config.ConverterClass(value=LocalDateTimeConverter.class)
    @Config.DefaultValue(value="1970-01-01T00:00:00")
    public LocalDateTime getValidMinTimestamp();

    @Config.Key(value="SINK_MAXCOMPUTE_VALID_MAX_TIMESTAMP")
    @Config.ConverterClass(value=LocalDateTimeConverter.class)
    @Config.DefaultValue(value="9999-12-31T23:59:59")
    public LocalDateTime getValidMaxTimestamp();

    @Config.Key(value="SINK_MAXCOMPUTE_MAX_PAST_EVENT_TIME_DIFFERENCE_YEAR")
    @Config.DefaultValue(value="5")
    public int getMaxPastYearEventTimeDifference();

    @Config.Key(value="SINK_MAXCOMPUTE_MAX_FUTURE_EVENT_TIME_DIFFERENCE_YEAR")
    @Config.DefaultValue(value="1")
    public int getMaxFutureYearEventTimeDifference();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_INTEGER_TYPES_TO_BIGINT_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isProtoIntegerTypesToBigintEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_FLOAT_TYPE_TO_DECIMAL_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isProtoFloatTypeToDecimalEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_FLOAT_TYPE_TO_DOUBLE_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isProtoFloatTypeToDoubleEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_FLOAT_TYPE_TO_DECIMAL_PRECISION")
    @Config.DefaultValue(value="38")
    public int getProtoFloatToDecimalPrecision();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_FLOAT_TYPE_TO_DECIMAL_SCALE")
    @Config.DefaultValue(value="18")
    public int getProtoFloatToDecimalScale();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_DOUBLE_TYPE_TO_DECIMAL_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isProtoDoubleToDecimalEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_DOUBLE_TYPE_TO_DECIMAL_PRECISION")
    @Config.DefaultValue(value="38")
    public int getProtoDoubleToDecimalPrecision();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_DOUBLE_TYPE_TO_DECIMAL_SCALE")
    @Config.DefaultValue(value="18")
    public int getProtoDoubleToDecimalScale();

    @Config.Key(value="SINK_MAXCOMPUTE_DECIMAL_ROUNDING_MODE")
    @Config.DefaultValue(value="UNNECESSARY")
    public RoundingMode getDecimalRoundingMode();

    @Config.Key(value="SINK_MAXCOMPUTE_TABLE_PROPERTIES")
    @Config.ConverterClass(value=KeyValuePairsToMapConverter.class)
    @Config.DefaultValue(value="")
    public Map<String, String> getTableProperties();

    @Config.Key(value="SINK_MAXCOMPUTE_NANO_HANDLING_ENABLED")
    @Config.DefaultValue(value="true")
    public boolean isNanoHandlingEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_PROTO_MAX_NESTED_MESSAGE_DEPTH")
    @Config.DefaultValue(value="15")
    public int getMaxNestedMessageDepth();

    @Config.Key(value="SINK_MAXCOMPUTE_IGNORE_NEGATIVE_SECOND_TIMESTAMP_ENABLED")
    @Config.DefaultValue(value="true")
    public boolean isIgnoreNegativeSecondTimestampEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_ALLOW_SCHEMA_MISMATCH_ENABLED")
    @Config.DefaultValue(value="false")
    public boolean isAllowSchemaMismatchEnabled();

    @Config.Key(value="SINK_MAXCOMPUTE_TIMESTAMP_TRUNCATE_MODE")
    @Config.DefaultValue(value="MICROS")
    public ChronoUnit getTimestampTruncateMode();
}

