/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.config;

import com.gotocompany.depot.config.SinkConfig;
import com.gotocompany.depot.config.converter.EmptyStringToNull;
import com.gotocompany.depot.config.converter.JsonToPropertiesConverter;
import com.gotocompany.depot.config.converter.RedisSinkDataTypeConverter;
import com.gotocompany.depot.config.converter.RedisSinkDeploymentTypeConverter;
import com.gotocompany.depot.config.converter.RedisSinkTtlTypeConverter;
import com.gotocompany.depot.config.preprocessor.Trim;
import com.gotocompany.depot.redis.enums.RedisSinkDataType;
import com.gotocompany.depot.redis.enums.RedisSinkDeploymentType;
import com.gotocompany.depot.redis.enums.RedisSinkTtlType;
import java.util.Properties;
import org.aeonbits.owner.Config;

@Config.DisableFeature(value={Config.DisableableFeature.PARAMETER_FORMATTING})
@Config.PreprocessorClasses(value={Trim.class})
public interface RedisSinkConfig
extends SinkConfig {
    @Config.Key(value="SINK_REDIS_URLS")
    public String getSinkRedisUrls();

    @Config.Key(value="SINK_REDIS_CLUSTER_MAX_ATTEMPTS")
    @Config.DefaultValue(value="5")
    public int getSinkRedisMaxAttempts();

    @Config.Key(value="SINK_REDIS_AUTH_USERNAME")
    @Config.ConverterClass(value=EmptyStringToNull.class)
    public String getSinkRedisAuthUsername();

    @Config.Key(value="SINK_REDIS_AUTH_PASSWORD")
    @Config.ConverterClass(value=EmptyStringToNull.class)
    public String getSinkRedisAuthPassword();

    @Config.Key(value="SINK_REDIS_CONNECTION_TIMEOUT_MS")
    @Config.DefaultValue(value="5000")
    public int getSinkRedisConnectionTimeoutMs();

    @Config.Key(value="SINK_REDIS_SOCKET_TIMEOUT_MS")
    @Config.DefaultValue(value="10000")
    public int getSinkRedisSocketTimeoutMs();

    @Config.Key(value="SINK_REDIS_KEY_TEMPLATE")
    public String getSinkRedisKeyTemplate();

    @Config.Key(value="SINK_REDIS_DATA_TYPE")
    @Config.DefaultValue(value="HASHSET")
    @Config.ConverterClass(value=RedisSinkDataTypeConverter.class)
    public RedisSinkDataType getSinkRedisDataType();

    @Config.Key(value="SINK_REDIS_TTL_TYPE")
    @Config.DefaultValue(value="DISABLE")
    @Config.ConverterClass(value=RedisSinkTtlTypeConverter.class)
    public RedisSinkTtlType getSinkRedisTtlType();

    @Config.Key(value="SINK_REDIS_TTL_VALUE")
    @Config.DefaultValue(value="0")
    public long getSinkRedisTtlValue();

    @Config.Key(value="SINK_REDIS_DEPLOYMENT_TYPE")
    @Config.DefaultValue(value="Standalone")
    @Config.ConverterClass(value=RedisSinkDeploymentTypeConverter.class)
    public RedisSinkDeploymentType getSinkRedisDeploymentType();

    @Config.Key(value="SINK_REDIS_KEY_VALUE_DATA_FIELD_NAME")
    public String getSinkRedisKeyValueDataFieldName();

    @Config.Key(value="SINK_REDIS_LIST_DATA_FIELD_NAME")
    public String getSinkRedisListDataFieldName();

    @Config.Key(value="SINK_REDIS_HASHSET_FIELD_TO_COLUMN_MAPPING")
    @Config.ConverterClass(value=JsonToPropertiesConverter.class)
    @Config.DefaultValue(value="")
    public Properties getSinkRedisHashsetFieldToColumnMapping();

    @Override
    @Config.Key(value="SINK_REDIS_DEFAULT_FIELD_VALUE_ENABLE")
    @Config.DefaultValue(value="true")
    public boolean getSinkDefaultFieldValueEnable();

    @Config.Key(value="SINK_REDIS_CONNECTION_MAX_RETRIES")
    @Config.DefaultValue(value="1")
    public int getSinkRedisConnectionMaxRetries();

    @Config.Key(value="SINK_REDIS_CONNECTION_RETRY_BACKOFF_MS")
    @Config.DefaultValue(value="2000")
    public long getSinkRedisConnectionRetryBackoffMs();
}

