/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.client;

import com.gotocompany.depot.http.record.HttpRequestRecord;
import com.gotocompany.depot.http.response.HttpSinkResponse;
import com.gotocompany.depot.metrics.HttpSinkMetrics;
import com.gotocompany.depot.metrics.Instrumentation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpClient;

public class HttpSinkClient {
    private final HttpClient httpClient;
    private final Instrumentation instrumentation;
    private final HttpSinkMetrics httpSinkMetrics;

    public HttpSinkClient(HttpClient httpClient, HttpSinkMetrics httpSinkMetrics, Instrumentation instrumentation) {
        this.httpClient = httpClient;
        this.instrumentation = instrumentation;
        this.httpSinkMetrics = httpSinkMetrics;
    }

    public List<HttpSinkResponse> send(List<HttpRequestRecord> records) throws IOException {
        ArrayList<HttpSinkResponse> responseList = new ArrayList<HttpSinkResponse>();
        for (HttpRequestRecord record : records) {
            HttpSinkResponse sinkResponse = record.send(this.httpClient, this.instrumentation);
            responseList.add(sinkResponse);
            this.instrument(sinkResponse);
        }
        return responseList;
    }

    private void instrument(HttpSinkResponse httpSinkResponse) {
        int statusCode = httpSinkResponse.getResponseCode();
        String httpCodeTag = statusCode < 0 ? "status_code=" : "status_code=" + statusCode;
        this.instrumentation.captureCount(this.httpSinkMetrics.getHttpResponseCodeTotalMetric(), 1L, httpCodeTag);
    }
}

