/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.record;

import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.http.response.HttpSinkResponse;
import com.gotocompany.depot.metrics.Instrumentation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class HttpRequestRecord
implements Iterable<Integer> {
    private final Set<Integer> recordIndexes = new HashSet<Integer>();
    private final ErrorInfo errorInfo;
    private final boolean valid;
    private final HttpEntityEnclosingRequestBase httpRequest;

    public HttpRequestRecord(ErrorInfo errorInfo, boolean valid, HttpEntityEnclosingRequestBase httpRequest) {
        this.errorInfo = errorInfo;
        this.valid = valid;
        this.httpRequest = httpRequest;
    }

    public HttpRequestRecord(HttpEntityEnclosingRequestBase httpRequest) {
        this(null, true, httpRequest);
    }

    public HttpRequestRecord(ErrorInfo errorInfo) {
        this(errorInfo, false, null);
    }

    public HttpSinkResponse send(HttpClient httpClient, Instrumentation instrumentation) throws IOException {
        HttpResponse response = httpClient.execute((HttpUriRequest)this.httpRequest);
        return new HttpSinkResponse(response, instrumentation);
    }

    public String getRequestBody() throws IOException {
        return EntityUtils.toString((HttpEntity)this.httpRequest.getEntity());
    }

    public void addIndex(Integer index) {
        this.recordIndexes.add(index);
    }

    public void addAllIndexes(Set<Integer> indexes) {
        this.recordIndexes.addAll(indexes);
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getRequestString() throws IOException {
        StringBuilder requestString = new StringBuilder().append("\nRequest Method: ").append(this.httpRequest.getMethod()).append("\nRequest Url: ").append(this.httpRequest.getURI()).append("\nRequest Headers: ").append(Arrays.asList(this.httpRequest.getAllHeaders()));
        if (this.httpRequest.getEntity() != null) {
            requestString.append("\nRequest Body: ").append(this.getRequestBody());
        }
        return requestString.toString();
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return this.recordIndexes.iterator();
    }
}

