/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request;

import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.exception.DeserializerException;
import com.gotocompany.depot.exception.EmptyMessageException;
import com.gotocompany.depot.http.enums.HttpRequestMethodType;
import com.gotocompany.depot.http.record.HttpRequestRecord;
import com.gotocompany.depot.http.request.Request;
import com.gotocompany.depot.http.request.RequestUtils;
import com.gotocompany.depot.http.request.body.RequestBody;
import com.gotocompany.depot.http.request.body.RequestBodyFactory;
import com.gotocompany.depot.http.request.builder.HeaderBuilder;
import com.gotocompany.depot.http.request.builder.QueryParamBuilder;
import com.gotocompany.depot.http.request.builder.UriBuilder;
import com.gotocompany.depot.message.Message;
import com.gotocompany.depot.message.MessageContainer;
import com.gotocompany.depot.message.MessageParser;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRequest
implements Request {
    private static final Logger log = LoggerFactory.getLogger(BatchRequest.class);
    private final Map<String, String> requestHeaders;
    private final URI requestUrl;
    private final RequestBody requestBody;
    private final HttpSinkConfig config;
    private final MessageParser parser;

    public BatchRequest(HeaderBuilder headerBuilder, QueryParamBuilder queryParamBuilder, UriBuilder uriBuilder, HttpSinkConfig config, MessageParser parser) {
        this.requestHeaders = headerBuilder.build();
        this.requestUrl = uriBuilder.build(queryParamBuilder.build());
        this.requestBody = RequestBodyFactory.create(config);
        this.config = config;
        this.parser = parser;
    }

    @Override
    public List<HttpRequestRecord> createRecords(List<Message> messages) {
        ArrayList<HttpRequestRecord> records = new ArrayList<HttpRequestRecord>();
        if (this.config.getSinkHttpRequestMethod() != HttpRequestMethodType.DELETE || this.config.isSinkHttpDeleteBodyEnable().booleanValue()) {
            this.createRecordsWithBody(messages, records);
        } else {
            HttpEntityEnclosingRequestBase request = RequestUtils.buildRequest(this.config, this.requestHeaders, this.requestUrl, null);
            records.add(new HttpRequestRecord(request));
        }
        return records;
    }

    private void createRecordsWithBody(List<Message> messages, ArrayList<HttpRequestRecord> records) {
        HashMap<Integer, String> validBodies = new HashMap<Integer, String>();
        for (int index = 0; index < messages.size(); ++index) {
            Message message = messages.get(index);
            MessageContainer messageContainer = new MessageContainer(message, this.parser);
            try {
                String body = this.requestBody.build(messageContainer);
                validBodies.put(index, body);
                continue;
            }
            catch (EmptyMessageException e) {
                records.add(RequestUtils.createErrorRecord(e, ErrorType.INVALID_MESSAGE_ERROR, index, message.getMetadata()));
                continue;
            }
            catch (ConfigurationException | IllegalArgumentException e) {
                records.add(RequestUtils.createErrorRecord(e, ErrorType.UNKNOWN_FIELDS_ERROR, index, message.getMetadata()));
                continue;
            }
            catch (DeserializerException | IOException e) {
                records.add(RequestUtils.createErrorRecord(e, ErrorType.DESERIALIZATION_ERROR, index, message.getMetadata()));
            }
        }
        if (validBodies.size() != 0) {
            HttpEntityEnclosingRequestBase request = RequestUtils.buildRequest(this.config, this.requestHeaders, this.requestUrl, validBodies.values());
            HttpRequestRecord validRecord = new HttpRequestRecord(request);
            validRecord.addAllIndexes(validBodies.keySet());
            records.add(validRecord);
        }
    }
}

