/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request;

import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.error.ErrorInfo;
import com.gotocompany.depot.error.ErrorType;
import com.gotocompany.depot.http.record.HttpRequestRecord;
import com.gotocompany.depot.http.request.RequestMethodFactory;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    protected static HttpRequestRecord createErrorRecord(Exception e, ErrorType type, Integer index, Map<String, Object> metadata) {
        ErrorInfo errorInfo = new ErrorInfo(e, type);
        log.error("Error while parsing record for message. Metadata : {}, Error: {}", metadata, (Object)errorInfo);
        HttpRequestRecord record = new HttpRequestRecord(errorInfo);
        record.addIndex(index);
        return record;
    }

    private static StringEntity buildStringEntity(Object input) {
        return new StringEntity(input.toString(), ContentType.APPLICATION_JSON);
    }

    public static HttpEntityEnclosingRequestBase buildRequest(HttpSinkConfig config, Map<String, String> headers, URI uri, Object requestBody) {
        HttpEntityEnclosingRequestBase request = RequestMethodFactory.create(uri, config.getSinkHttpRequestMethod());
        headers.forEach((arg_0, arg_1) -> ((HttpEntityEnclosingRequestBase)request).addHeader(arg_0, arg_1));
        if (requestBody != null) {
            request.setEntity((HttpEntity)RequestUtils.buildStringEntity(requestBody));
        }
        return request;
    }
}

