/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request.body;

import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.http.request.body.RequestBody;
import com.gotocompany.depot.message.MessageContainer;
import com.gotocompany.depot.message.MessageUtils;
import com.gotocompany.depot.message.ParsedMessage;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class JsonBody
implements RequestBody {
    private static final String METADATA_PREFIX = "message_";
    private final HttpSinkConfig config;

    public JsonBody(HttpSinkConfig config) {
        this.config = config;
    }

    @Override
    public String build(MessageContainer messageContainer) throws IOException {
        ParsedMessage parsedLogKey = messageContainer.getParsedLogKey(this.config.getSinkConnectorSchemaProtoKeyClass());
        ParsedMessage parsedLogMessage = messageContainer.getParsedLogMessage(this.config.getSinkConnectorSchemaProtoMessageClass());
        JSONObject payload = new JSONObject();
        payload.put("logKey", (Object)this.buildJsonMessage(parsedLogKey));
        payload.put("logMessage", (Object)this.buildJsonMessage(parsedLogMessage));
        MessageUtils.getMetaData(messageContainer.getMessage(), this.config, Date::new).forEach((key, value) -> payload.put(this.removePrefixMetadata((String)key), value));
        return payload.toString();
    }

    private String buildJsonMessage(ParsedMessage parsedMessage) {
        JSONObject jsonMessage = parsedMessage.toJson();
        return jsonMessage.toString();
    }

    private String removePrefixMetadata(String metadataFieldName) {
        return StringUtils.removeStart((String)metadataFieldName, (String)METADATA_PREFIX);
    }
}

