/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request.body;

import com.fasterxml.jackson.databind.JsonNode;
import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.http.request.body.RequestBody;
import com.gotocompany.depot.http.request.util.JsonParserUtils;
import com.gotocompany.depot.message.MessageContainer;
import com.gotocompany.depot.message.ParsedMessage;
import com.gotocompany.depot.message.SinkConnectorSchemaMessageMode;
import java.io.IOException;

public class TemplatizedJsonBody
implements RequestBody {
    private final JsonNode templateJsonNode;
    private final HttpSinkConfig config;

    public TemplatizedJsonBody(HttpSinkConfig config) {
        this.config = config;
        this.templateJsonNode = JsonParserUtils.createJsonNode(config.getSinkHttpJsonBodyTemplate());
    }

    @Override
    public String build(MessageContainer msgContainer) throws IOException {
        ParsedMessage parsedMessage = this.config.getSinkConnectorSchemaMessageMode() == SinkConnectorSchemaMessageMode.LOG_KEY ? msgContainer.getParsedLogKey(this.config.getSinkConnectorSchemaProtoKeyClass()) : msgContainer.getParsedLogMessage(this.config.getSinkConnectorSchemaProtoMessageClass());
        JsonNode parsedJsonNode = JsonParserUtils.parse(this.templateJsonNode, parsedMessage);
        return parsedJsonNode.toString();
    }
}

