/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.depot.http.request.builder;

import com.gotocompany.depot.common.Template;
import com.gotocompany.depot.common.TemplateUtils;
import com.gotocompany.depot.config.HttpSinkConfig;
import com.gotocompany.depot.exception.ConfigurationException;
import com.gotocompany.depot.http.enums.HttpParameterSourceType;
import com.gotocompany.depot.message.MessageContainer;
import java.io.IOException;
import java.util.Map;

public class HeaderBuilder {
    private final Map<String, String> baseHeaders;
    private final Map<Template, Template> headersTemplate;
    private final HttpParameterSourceType headersParameterSource;
    private final String schemaProtoKeyClass;
    private final String schemaProtoMessageClass;

    public HeaderBuilder(HttpSinkConfig config) {
        this.baseHeaders = config.getSinkHttpHeaders();
        this.headersTemplate = config.getSinkHttpHeadersTemplate();
        this.headersParameterSource = config.getSinkHttpHeadersParameterSource();
        this.schemaProtoKeyClass = config.getSinkConnectorSchemaProtoKeyClass();
        this.schemaProtoMessageClass = config.getSinkConnectorSchemaProtoMessageClass();
    }

    public Map<String, String> build() {
        if (!this.headersTemplate.isEmpty()) {
            throw new ConfigurationException("Header template is not allowed in batch request mode.");
        }
        return this.baseHeaders;
    }

    public Map<String, String> build(MessageContainer msgContainer) throws IOException {
        Map<String, String> headers = this.headersParameterSource == HttpParameterSourceType.KEY ? TemplateUtils.parseTemplateMap(this.headersTemplate, msgContainer.getParsedLogKey(this.schemaProtoKeyClass)) : TemplateUtils.parseTemplateMap(this.headersTemplate, msgContainer.getParsedLogMessage(this.schemaProtoMessageClass));
        this.baseHeaders.putAll(headers);
        return this.baseHeaders;
    }

    public Map<String, String> getBaseHeaders() {
        return this.baseHeaders;
    }

    public Map<Template, Template> getHeadersTemplate() {
        return this.headersTemplate;
    }

    public HttpParameterSourceType getHeadersParameterSource() {
        return this.headersParameterSource;
    }

    public String getSchemaProtoKeyClass() {
        return this.schemaProtoKeyClass;
    }

    public String getSchemaProtoMessageClass() {
        return this.schemaProtoMessageClass;
    }
}

